# coding: utf8
from sandbox import sdk2
from sandbox.common import errors, utils
from sandbox.common.types import client as ctc
from sandbox.common.types import task as ctt


class MartyReleaseYaPackageTask(sdk2.Task):
    '''
    - Release YA_PACKAGE task with resources
    '''

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        release_subject = sdk2.parameters.String('Release subject', default='', required=False)
        ya_package_task_id = sdk2.parameters.Task('YA_PACKAGE Task', task_type="YA_PACKAGE", required=True)

    def on_execute(self):
        ya_package_task = self.Parameters.ya_package_task_id
        with self.memoize_stage.wait_for_parent:
            if ya_package_task.status not in set(utils.chain(ctt.Status.Group.FINISH, ctt.Status.Group.BREAK)):
                raise sdk2.WaitTask(
                    ya_package_task.id, set(utils.chain(ctt.Status.Group.FINISH, ctt.Status.Group.BREAK))
                )

            if ya_package_task.status not in ctt.Status.Group.SUCCEED:
                raise errors.TaskFailure('Parent YA_PACKAGE task had not succeeded')

        with self.memoize_stage.deploy:
            msg_parts = self.Parameters.release_subject.split('\n', 1)
            title = msg_parts.pop(0)
            msg_parts.append(ya_package_task.Context.output_resource_version)
            description = '\n'.join(msg_parts)
            self.server.release(
                task_id=ya_package_task.id,
                type=ctt.ReleaseStatus.TESTING,
                subject=title,
                message=description,
            )
