PRAGMA RegexUseRe2="true";
USE hahn;

$signalsPathPrefix = "//logs/analyzer-dispatcher-signals-log/stream/5min/";
$curTableNames = {table_names};
$curTables = ListMap($curTableNames, ($name) -> {{
    RETURN $signalsPathPrefix || $name;
}});

SELECT
    `clid`, `vehicle_type`, `route`,
    COUNT(*) AS `count`
FROM EACH($curTables)
WHERE `route` IS NOT NULL  -- filters masstransit signals from everything else
    -- safety measure to avoid clids like "../../../../etc/fstab"
    AND `clid` REGEXP  "^[-a-zA-Z0-9_]*$"
GROUP BY `clid`, `vehicle_type`, `route`
ORDER BY `clid`, `vehicle_type`, `route`;

SELECT
    `clid`, `uuid`, `route`,
    COUNT(*) AS `count`
FROM EACH($curTables)
WHERE `route` IS NOT NULL
    AND `clid` REGEXP  "^[-a-zA-Z0-9_]*$"
GROUP BY `clid`, `uuid`, `route`
ORDER BY `clid`, `uuid`, `route`;
