from sandbox import sdk2


class MapsMasstransitPrepareRandomMatricesAmmo(sdk2.Task):

    class Parameters(sdk2.Parameters):
        resource_type = sdk2.parameters.String(
            "Resource type to be created",
            required=True)
        requests_number = sdk2.parameters.Integer(
            "Number of requests to be generated",
            required=True)
        minimum_matrix_src_size = sdk2.parameters.Integer(
            "Minimum matrix source points size",
            default=1
        )
        minimum_matrix_dst_size = sdk2.parameters.Integer(
            "Minimum matrix destination points size ",
            required=True
        )
        maximum_matrix_src_size = sdk2.parameters.Integer(
            "Maximum matrix source points size",
            default=1
        )
        maximum_matrix_dst_size = sdk2.parameters.Integer(
            "Maximum matrix destination points size",
            required=True
        )
        handle = sdk2.parameters.String(
            "Ammo handle",
            required=True,
            default='/pedestrian/v2/matrix'
        )

        # Default values describe square 5x5 km in Moscow
        lat_top_left_point_random_area = sdk2.parameters.Float(
            "Latitude of top left point of random area",
            default=55.743573
        )
        lon_top_left_point_random_area = sdk2.parameters.Float(
            "Longitude of top left point of random area",
            default=37.637705
        )
        lat_bottom_right_point_random_area = sdk2.parameters.Float(
            "Latitude of bottom right point of random area",
            default=55.789147
        )
        lon_bottom_right_point_random_area = sdk2.parameters.Float(
            "Longitude of bottom right point of random area",
            default=37.560438
        )

        generate_post_requests = sdk2.parameters.Bool(
            "Produce protobuf requests (for POST API)",
            default=False
        )

        with sdk2.parameters.Output:
            ammo = sdk2.parameters.Resource("Result ammo", required=True)

    def _write_result(self, ammo_rows):
        description = "Random matrices {} ammo".format(self.Parameters.handle)
        resource = sdk2.Resource[self.Parameters.resource_type](
            self,
            description,
            "random_matrices_ammo.txt",
            sync_upload_to_mds=True
        )
        resource_data = sdk2.ResourceData(resource)
        with resource_data.path.open("wb") as ammo_file:
            ammo_file.writelines(ammo_rows)
        resource_data.ready()
        self.Parameters.ammo = resource

    def on_execute(self):
        import prepare_ammo
        self._write_result(prepare_ammo.prepare_ammo(self.Parameters))
