import random
from yandex.maps.proto.masstransit_matrix.request_pb2 import Request as MatrixRequest


class PrepareAmmo:
    def __init__(self, params):
        self.Parameters = params

    def _random_point(self):
        random_lat = random.uniform(
            self.Parameters.lat_bottom_right_point_random_area,
            self.Parameters.lat_top_left_point_random_area
        )
        random_lon = random.uniform(
            self.Parameters.lon_top_left_point_random_area,
            self.Parameters.lon_bottom_right_point_random_area
        )
        return (random_lon, random_lat)

    def _generate_random_points(self, min_points_number, max_points_number):
        points_number = random.randint(
            min_points_number,
            max_points_number
        )
        return '~'.join("{:.7f},{:.7f}".format(*self._random_point()) for point in range(points_number))

    def _generate_random_ammo(self):
        random.seed()
        ammo = []
        for _ in range(self.Parameters.requests_number):
            src_points = self._generate_random_points(
                self.Parameters.minimum_matrix_src_size,
                self.Parameters.maximum_matrix_src_size
            )
            dst_points = self._generate_random_points(
                self.Parameters.minimum_matrix_dst_size,
                self.Parameters.maximum_matrix_dst_size
            )
            request = b"{handle}?srcll={}&dstll={} {handle}\n".\
                format(
                    src_points, dst_points,
                    handle=self.Parameters.handle
                )
            ammo += [request]
        return ammo

    def _generate_random_points_pb(self, result, min_points_number, max_points_number):
        points_number = random.randint(
            min_points_number,
            max_points_number
        )
        for i in range(points_number):
            point = result.add()
            (point.lon, point.lat) = self._random_point()

    def _generate_random_ammo_pb(self):
        ammo = []
        for _ in range(self.Parameters.requests_number):
            req = MatrixRequest()
            self._generate_random_points_pb(
                req.srcll,
                self.Parameters.minimum_matrix_src_size,
                self.Parameters.maximum_matrix_src_size
            )
            self._generate_random_points_pb(
                req.dstll,
                self.Parameters.minimum_matrix_dst_size,
                self.Parameters.maximum_matrix_dst_size
            )
            serialized = req.SerializeToString()
            request = b"{bodylen} {handle}\n{body}\n".\
                format(
                    handle=self.Parameters.handle,
                    bodylen=len(serialized),
                    body=serialized
                )
            ammo += [request]
        return ammo

    def prepare_ammo(self):
        if self.Parameters.generate_post_requests:
            return self._generate_random_ammo_pb()
        else:
            return self._generate_random_ammo()


def prepare_ammo(params):
    p = PrepareAmmo(params)
    return p.prepare_ammo()
