import logging
import subprocess

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.sdk2.helpers import ProcessLog
from sandbox.sdk2 import ssh
from sandbox.sdk2 import yav

from sandbox.projects.masstransit.common.utils import determine_nanny_hosts
from sandbox.projects.masstransit.common.constants import ROBOT_USERNAME


RESTART_SCRIPT_PATH = "/usr/local/bin/restart-service.sh"

YAV_SEC = "sec-01cne6g242ks89jtezszkbwfab"
YAV_VER = "ver-01drxtek1qnvxwe95y6hh68932"
YAV_SSH_KEY_NAME = "rsa-key-20181120"


class MapsMasstransitRestartService(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 15 * 60  # 15 min

        nanny_service_id = sdk2.parameters.String(
            "Nanny service id",
            default="maps_core_masstransit_router_load",
            required=True
        )

    def restart_service(self, hostname):
        ssh_key = yav.Secret(YAV_SEC, YAV_VER).data()[YAV_SSH_KEY_NAME]

        with ssh.Key(private_part=ssh_key):
            logger = logging.getLogger("ssh to {}".format(hostname))
            with ProcessLog(self, logger=logger) as log:
                ssh_process = subprocess.Popen(
                    "ssh -l {} {} {}".format(
                        ROBOT_USERNAME,
                        hostname,
                        RESTART_SCRIPT_PATH
                    ),
                    shell=True,
                    stdout=log.stdout,
                    stderr=log.stdout
                )
                if ssh_process.wait() != 0:
                    error = "ssh subprocess finished with non-zero return code"
                    raise TaskFailure(error)

    def on_execute(self):
        for hostname in determine_nanny_hosts(self.Parameters.nanny_service_id):
            self.restart_service(hostname)
