from sandbox import sdk2
from sandbox.projects.common.binary_task import deprecated as binary_task
from sandbox.projects.garden.common import config as garden_config
from sandbox.sdk2.vcs.svn import Arcadia

import garden

import datetime
import logging


GARDEN_ENVIRONMENTS = {
    "TESTING": garden_config.server_hostname("testing"),
    "PRODUCTION": garden_config.server_hostname("stable"),
}


def today_date():
    date = datetime.datetime.today().date()
    return date.strftime("%Y%m%d")


class MapsMasstransitMgtBlacklistResource(sdk2.Resource):
    pass


class MapsMasstransitUploadMgtBlacklist(binary_task.LastBinaryTaskRelease, sdk2.Task):

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 10 * 60

        blacklist_path = sdk2.parameters.String(
            "Path to the blacklist in arcadia",
            default="arcadia:/arc/trunk/arcadia/maps/masstransit/configs/mgt_blacklist/blacklist.txt",
            required=True
        )
        with sdk2.parameters.String("Garden environment", required=True) as garden:
            garden.values.CUSTOM = garden.Value(default=True)
            garden.values.TESTING = None
            garden.values.PRODUCTION = None
        with garden.value["CUSTOM"]:
            garden_manager = sdk2.parameters.String("Garden manager host")
        contour_name = sdk2.parameters.String("Name of the Garden contour", default="stable", required=True)
        build_name = sdk2.parameters.String("Name of the build in garden")

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_save(self):
        super(MapsMasstransitUploadMgtBlacklist, self).on_save()
        if not self.Parameters.build_name:
            self.Parameters.build_name = "{}-{}".format(today_date(), self.id)
        if self.Parameters.garden in GARDEN_ENVIRONMENTS:
            self.Parameters.garden_manager = GARDEN_ENVIRONMENTS[self.Parameters.garden]

    def on_execute(self):
        super(MapsMasstransitUploadMgtBlacklist, self).on_execute()
        self.Context.svn_revision = Arcadia.get_revision(self.Parameters.blacklist_path)
        blacklist_resource = MapsMasstransitMgtBlacklistResource(
            self,
            "MGT schedule blacklist",
            "blacklist.txt")
        blacklist_resource_data = sdk2.ResourceData(blacklist_resource)
        Arcadia.export(
            self.Parameters.blacklist_path,
            str(blacklist_resource_data.path),
            revision=self.Context.svn_revision)
        blacklist_resource_data.ready()

        garden.post_build(
            blacklist_resource.http_proxy,
            self.Parameters.garden_manager,
            self.Parameters.contour_name,
            self.Parameters.build_name,
            self.author,
            blacklist_resource.id)
        logging.info("Blacklist has been successfully uploaded to garden")
