import requests


MODULE_NAME = "mgt_blacklist_src"
RESOURCE_NAME = "mgt_blacklist_src"
GARDEN_BUILDS_URL = "http://{garden_host}/garden/modules/{module}/builds/"


def post_build(blacklist_url, garden_host, contour_name, build_name, user, resource_id):
    url = GARDEN_BUILDS_URL.format(garden_host=garden_host, module=MODULE_NAME)
    response = requests.post(url, auth=(user, ""), json={
        "contour": contour_name,
        "foreign_key": {
            "sandbox_resource_id": str(resource_id)
        },
        "resources": [
            {
                "name": RESOURCE_NAME,
                "version": {
                    "properties": {
                        "shipping_date": build_name,
                        "url": blacklist_url
                    }
                }
            }
        ]
    })
    response.raise_for_status()
