from sandbox import sdk2


class MapsMasstransitReleasable(sdk2.resource.AbstractResource):
    """
    Base class for resource that can be released by garden module
    """

    releasers = ["MAPS-MASSTRANSIT", "MAPS_GARDEN"]
    releasable = True


class MapsMasstransitDataMms(MapsMasstransitReleasable):
    """
    Memory mapped file with entities from yandex-maps-masstransit-data
    Included in ecstatic datasets yandex-maps-mtgpsmodel-{datatesting, production}
    Released by garden module mtgps_model_builder
    """


class MapsMasstransitProductionLogAmmo(sdk2.Resource):
    """
    Base class of masstransit production log ammo
    """
    log_date = sdk2.parameters.String(
        "Date of production log",
        required=True
    )


class MapsMasstransitPedestrianGraph(MapsMasstransitReleasable):
    """
    Pedestrian graph for masstransit router
    Released by garden module masstransit
    """


class MapsMasstransitPedestrianGraphFb(MapsMasstransitReleasable):
    """
    Pedestrian graph (fb format) for masstransit router
    Released by garden module masstransit
    """


class MASSTRANSIT_DATA(MapsMasstransitReleasable):
    """
    Export of yandex-maps-masstransit-data dataset. Uploaded automatically from garden.
    """


class MASSTRANSIT_DATA_RASP(MapsMasstransitReleasable):
    """
    Export of yandex-maps-masstransit-data-rasp dataset. Uploaded automatically from garden.
    """
    auto_backup = True


class MapsMasstransitPedestrianValidationReport(sdk2.resource.AbstractResource):
    """
    Report of validating pedestrian graph in the garden module masstransit_tester
    """
