import requests

from sandbox import sdk2
from sandbox.projects.masstransit.updateGTFS.MapsMasstransitUpdateGtfsSource import (
    MapsMasstransitUpdateGtfsSource as BaseTask,
)


class MapsMasstransitUpdateGtfsSourceWithAuth(BaseTask):
    """
        Base Task for downloading gtfs.zip with auth
    """
    class Parameters(BaseTask.Parameters):
        with sdk2.parameters.Group("Authentification") as g:
            login = sdk2.parameters.String("Login", required=True)
            vault_key = sdk2.parameters.String("Vault key", required=True)

    def create_session(self):
        s = requests.Session()
        s.auth = (
            self.Parameters.login,
            sdk2.Vault.data('MAPS-MASSTRANSIT', self.Parameters.vault_key)
        )
        return s
