import logging

from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.nanny import nanny
from sandbox.projects.matrix.resources import (
    MatrixSchedulerBinary,

    MatrixSchedulerConfigProduction,
    MatrixSchedulerConfigTesting,

    MatrixSchedulerInstancectlConfig,
    MatrixSchedulerLogrotateConfig,
    MatrixSchedulerPushClientConfig,
)


class BuildMatrixScheduler(YaMakeTemplate.YaMakeTemplate):
    """
        Build matrix scheduler binary.
    """
    class Parameters(YaMakeTemplate.get_project_params(
        build_resources=[MatrixSchedulerBinary],
        source_resources=[
            (resource, resource.arcadia_build_path) for resource in (
                MatrixSchedulerConfigProduction,
                MatrixSchedulerConfigTesting,

                MatrixSchedulerInstancectlConfig,
                MatrixSchedulerLogrotateConfig,
                MatrixSchedulerPushClientConfig,
            )
        ],
    )):
        pass

    def on_release(self, parameters_):
        logging.debug("Release parameters: %r", parameters_)
        self._send_release_info_to_email(parameters_)
        self.mark_released_resources(parameters_["release_status"])

        nanny.ReleaseToNannyTask2.on_release(self, parameters_)
