import logging

from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.nanny import nanny
from sandbox.projects.matrix.resources import (
    MatrixWorkerBinary,

    MatrixWorkerConfigProduction,
    MatrixWorkerConfigTesting,

    MatrixWorkerInstancectlConfig,
    MatrixWorkerLogrotateConfig,
    MatrixWorkerPushClientConfig,
)


class BuildMatrixWorker(YaMakeTemplate.YaMakeTemplate):
    """
        Build matrix worker binary.
    """
    class Parameters(YaMakeTemplate.get_project_params(
        build_resources=[MatrixWorkerBinary],
        source_resources=[
            (resource, resource.arcadia_build_path) for resource in (
                MatrixWorkerConfigProduction,
                MatrixWorkerConfigTesting,

                MatrixWorkerInstancectlConfig,
                MatrixWorkerLogrotateConfig,
                MatrixWorkerPushClientConfig,
            )
        ],
    )):
        pass

    def on_release(self, parameters_):
        logging.debug("Release parameters: %r", parameters_)
        self._send_release_info_to_email(parameters_)
        self.mark_released_resources(parameters_["release_status"])

        nanny.ReleaseToNannyTask2.on_release(self, parameters_)
