from sandbox import sdk2


class MatrixResourceBase(sdk2.Resource):
    releasable = True
    releasers = [
        "chegoryu",
        "elshiko",

        # Matrix ci robot and release machine robot
        "robot-matrix-ci",
        "robot-srch-releaser",
    ]


class MatrixConfigBase(MatrixResourceBase):
    any_arch = True
    executable = False


# Matrix
class MatrixBinary(MatrixResourceBase):
    executable = True
    any_arch = False
    arcadia_build_path = "alice/matrix/notificator/bin/matrix"


class MatrixConfigDev(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/notificator/configs/matrix_config_dev.json"


class MatrixConfigProduction(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/notificator/configs/matrix_config_production.json"


class MatrixConfigTesting(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/notificator/configs/matrix_config_testing.json"


class MatrixInstancectlConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/notificator/configs/instancectl.conf"


class MatrixLogrotateConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/notificator/configs/logrotate.conf"


class MatrixPushClientConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/notificator/configs/push_client_config.yaml"


class MatrixTvmToolConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/notificator/configs/tvmtool_config.json"


# Matrix scheduler
class MatrixSchedulerBinary(MatrixResourceBase):
    executable = True
    any_arch = False
    arcadia_build_path = "alice/matrix/scheduler/bin/matrix_scheduler"


class MatrixSchedulerConfigProduction(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/scheduler/configs/matrix_scheduler_config_production.json"


class MatrixSchedulerConfigTesting(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/scheduler/configs/matrix_scheduler_config_testing.json"


class MatrixSchedulerInstancectlConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/scheduler/configs/instancectl.conf"


class MatrixSchedulerLogrotateConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/scheduler/configs/logrotate.conf"


class MatrixSchedulerPushClientConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/scheduler/configs/push_client_config.yaml"


# Matrix worker
class MatrixWorkerBinary(MatrixResourceBase):
    executable = True
    any_arch = False
    arcadia_build_path = "alice/matrix/worker/bin/matrix_worker"


class MatrixWorkerConfigProduction(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/worker/configs/matrix_worker_config_production.json"


class MatrixWorkerConfigTesting(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/worker/configs/matrix_worker_config_testing.json"


class MatrixWorkerInstancectlConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/worker/configs/instancectl.conf"


class MatrixWorkerLogrotateConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/worker/configs/logrotate.conf"


class MatrixWorkerPushClientConfig(MatrixConfigBase):
    arcadia_build_path = "alice/matrix/worker/configs/push_client_config.yaml"
