from sandbox import sdk2
from sandbox.common import errors as ce
from sandbox.common.types import misc as ctm
import sandbox.common.types.client as ctc

import os.path
import requests
import os


class GeeseFSTests(sdk2.Task):
    """ GeeseFS tests against MDS storage """

    class Requirements(sdk2.Requirements):
        disk_space = 1024   # 1GiB on disk
        cores = 2
        ram = 3072          # 3GiB or less
        dns = ctm.DnsType.DNS64
        client_tags = ctc.Tag.LINUX_FOCAL

    class Parameters(sdk2.Task.Parameters):
        tokens = sdk2.parameters.YavSecret(
            "s3-geesefs-test-key",
            default=""
        )
        test_endpoint = sdk2.parameters.String('S3 test endpoint', default='https://s3.mdst.yandex.net')
        main_binary = sdk2.parameters.String('GeeseFS main binary', default='https://storage.yandexcloud.net/geesefs/geesefs-linux-amd64')
        test_binary = sdk2.parameters.String('GeeseFS tests binary', default='https://storage.yandexcloud.net/geesefs/geesefs-tests-linux-amd64')
        debug_mode = sdk2.parameters.Bool('Debug mode', default=False)

    def on_execute(self):
        tokens = self.Parameters.tokens.data()
        access_key = tokens["ACCESS_KEY"]
        secret_key = tokens["SECRET_KEY"]
        endpoint = self.Parameters.test_endpoint

        get_source(self.Parameters.main_binary, 'geesefs')
        get_source(self.Parameters.test_binary, 'geesefs_test')
        os.chmod('geesefs', 755)
        os.chmod('geesefs_test', 755)

        env = dict(os.environ)
        env["AWS_ACCESS_KEY_ID"] = access_key
        env["AWS_SECRET_ACCESS_KEY"] = secret_key
        env["ENDPOINT"] = endpoint
        env["CLOUD"] = "s3"
        env["YANDEX"] = "1"
        env["GEESEFS_BINARY"] = "./geesefs"
        if self.Parameters.debug_mode:
            env["DEBUG"] = "1"
        if "TMPDIR" not in env and "TMP" in env:
            env["TMPDIR"] = env["TMP"]
        env["PATH"] = "/skynet/python/bin:"+env["PATH"]
        with sdk2.helpers.ProcessLog(self, logger="shell") as pl:
            sdk2.helpers.subprocess.check_call(
                ["./geesefs_test"],
                stdout=pl.stdout, stderr=pl.stderr,
                env=env
            )

# ==== End Of Class ==== #


def get_source(url, dst):
    session = requests.session()
    try:
        with open(dst, 'wb') as resource:
            resource.write(session.get(url, stream=True).content)
        return os.path.abspath(dst)
    except Exception as ex:
        raise ce.TaskFailure("Can't download resource. {}".format(ex))
    finally:
        session.close()
