"""Import modules"""
import logging
import time
import os
from sandbox import sdk2
from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk.process import run_process

""" Docs: https://deploy.yandex-team.ru/docs/reference/tools/dctl """


class MediaCheckDeployRelease(sdk2.Task):
    """MediaCheckDeployRelease"""
    class Parameters(sdk2.Parameters):
        """Parameters"""
        yp_cluster = sdk2.parameters.String('yp_cluster')
        yp_token = sdk2.parameters.String("yp_token", do_not_copy=True)
        stage_id = sdk2.parameters.String("stage_id")
        deploy_unit = sdk2.parameters.String("deploy_unit")
        timeout = sdk2.parameters.String("timeout")

    ya_dctl = None
    count_get_rs = 0

    def get_ya_dctl(self):
        ya = svn.Arcadia.export('arcadia:/arc/trunk/arcadia/ya', os.path.realpath('ya'))
        ya_dctl = f"{ya} dctl"
        logging.info(f"ya_dctl: {ya_dctl}")
        secret = sdk2.yav.Secret(self.Parameters.yp_token)
        yp_token = secret.data()["yp-token"]
        ya_token = secret.data()["ya_token"]
        os.environ["YA_TOKEN"] = ya_token
        os.environ["DCTL_YP_TOKEN"] = yp_token

        # First Run_process yp-util for download without param
        run_process(ya_dctl.split(), log_prefix='ya_dctl_out_download', timeout=600).wait()
        return ya_dctl

    def get_replica_set(self, stage_id, deploy_unit):
        """ Get replica set """
        self.count_get_rs += 1
        cmd = f"""{self.ya_dctl} status rs {stage_id}.{deploy_unit} -c {self.Parameters.yp_cluster}""".split()
        run_process(cmd, log_prefix=f'ya_dctl_status_ps_{stage_id}.{deploy_unit}_{self.count_get_rs}', timeout=600).wait()
        with open(f"log1/ya_dctl_status_ps_{stage_id}.{deploy_unit}_{self.count_get_rs}.out.txt") as out:
            try:
                status = out.read().split('|')
                status_ps = {'rev': status[5].strip(), 'rev_pods': status[6].strip()}
                return {"status": True, "data": status_ps}
            except ValueError as error_text:
                return {"status": False, "error": error_text}

    def set_db(self, stage_id, deploy_unit, rev, count_pods):
        """ Set disruption budget"""
        cmd = f"""{self.ya_dctl} control stage override_deployment_strategy {stage_id} --cluster-to-override
            {self.Parameters.yp_cluster} --revision {rev}
            --deploy-unit-id {deploy_unit} --max-unavailable {count_pods} -c xdc"""
        run_process(cmd, log_prefix=f'ya_dctl_control_stage_{stage_id}.{deploy_unit}', timeout=600).wait()
        return(True)

    def main(self):
        """Main"""
        # Ждем минуту начала деплоя
        time.sleep(60)
        if self.ya_dctl is None:
            self.ya_dctl = self.get_ya_dctl()

        # Получаем текущую ревизию
        status_rs = self.get_replica_set(self.Parameters.stage_id, self.Parameters.deploy_unit)
        logging.info(status_rs)
        count_pods = status_rs['data']['rev_pods'].split('/')[2]
        logging.info(count_pods)
        # Выставляем дистрапшет баджет
        if self.set_db(self.Parameters.stage_id, self.Parameters.deploy_unit, status_rs['data']['rev'], count_pods):

            seconds = 0
            while seconds < int(self.Parameters.timeout):
                status_rs = self.get_replica_set(self.Parameters.stage_id, self.Parameters.deploy_unit)
                logging.info(status_rs)
                count_pods = status_rs['data']['rev_pods'].split('/')[2]
                ready_pods = status_rs['data']['rev_pods'].split('/')[0]
                inprogress_pods = status_rs['data']['rev_pods'].split('/')[1]
                if int(inprogress_pods) == 0 and int(count_pods) == int(ready_pods):
                    return(True)
                seconds += 10
                time.sleep(10)
        logging.error("Timeout")
        exit(1)

    def on_execute(self):
        try:
            self.main()
        except RuntimeError as error:
            logging.error(f"ERROR: {error}\n")
