"""Import modules"""
import logging
import json
import boto3
import os
from sandbox import sdk2
from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk.process import run_process


class MediaGenCacheMapService(sdk2.Task):
    """MediaGenCacheMapService"""

    class Parameters(sdk2.Parameters):
        """Parameters"""
        clusters = sdk2.parameters.List('clusters')
        secrets = sdk2.parameters.String("s3 vault access_key and secret_key", do_not_copy=True)

    path_yp_util = None

    def get_path_yp_util(self):
        """Start ya tool and getting path for yp-util and environment"""
        ya_tool = svn.Arcadia.export('arcadia:/arc/trunk/arcadia/ya', os.path.realpath('ya'))
        path_yp_util = f"{ya_tool} tool yp-util"
        logging.info(f"path_yo_util: {path_yp_util}")
        self.secret = sdk2.yav.Secret(self.Parameters.secrets)
        yp_token = self.secret.data()["yp-token"]
        ya_token = self.secret.data()["ya_token"]
        os.environ["YA_TOKEN"] = ya_token
        os.environ["YP_TOKEN"] = yp_token

        # First Run_process yp-util for download without param
        run_process(path_yp_util.split(), log_prefix='yp-util_out_download').wait()
        return path_yp_util

    def cache(self, cluster):
        ''' Gen cache '''

        cmd = f"{self.path_yp_util} pods-list --cluster {cluster} --format json"
        run_process(cmd, log_prefix=f"yp-util_out_{cluster}").wait()
        with open(f"log1/yp-util_out_{cluster}.out.txt") as out:
            return {"status": True, "data": json.loads(out.read())}

    def main(self):
        if self.path_yp_util is None:
            self.path_yp_util = self.get_path_yp_util()
        cached = {}
        for cluster in self.Parameters.clusters:
            cached[cluster] = {}
            for pod in self.cache(cluster):
                cached[cluster][pod['pod_id']] = pod['pod_set_id']
        with open('map_cache.txt', 'w') as f:
            f.write(json.dumps(cached))
        s3_cfg = json.loads(self.secret.data()["s3_config"])
        s3 = boto3.client('s3', aws_access_key_id=s3_cfg["AccessKeyId"],
                          aws_secret_access_key=s3_cfg["AccessSecretKey"],
                          endpoint_url="https://kp-sre-map-services.s3.mds.yandex.net")

        s3.upload_file('map_cache.txt', 'cache', Key='map_cache.txt')
        return True

    def on_execute(self):
        try:
            self.main()
        except RuntimeError as error:
            logging.error(f"ERROR: {error}\n")
