#!/usr/bin/env bash
set -e


YA="../../../ya"                              #  ya bin
TARGET="${1}"                                 #  e.g.: admins/platformcheckcerts
TASK=$(echo "${TARGET}" | awk -F\/ '{print $NF}')
# Convert task name to sandbox format
TASK=$(echo -e "import re\ndata='${TASK}'\nif data.isupper():\n    print(data)\nelse:\n     print(re.sub(r'(?<!^)(?=[A-Z0-9])', '_', data).upper())" | python)
TARGET_PREFIX="media"
RELEASE_TYPE="${2:-test}"                     #  Release type for debug


function usage {
    echo -n "Usage: ./$(basename $0) "
    echo -n "[Path to task sources inside ${TARGET_PREFIX} sandbox project:admins/platformcheckcerts] "
    echo "[Release type stable|test:test]"
    exit 0
}


function check {
    #  Check files
    if [[ ! -d "${TARGET}/bin" ]] || [[ ! -f "${TARGET}/bin/ya.make" ]]; then
        echo "No ${TARGET}/bin dir, or no ya.make in ${TARGET}/bin dir. Could not proceed"
        exit 0
    fi
    # Check args
    if [[ "${RELEASE_TYPE}" != "stable" ]] && [[ "${RELEASE_TYPE}" != "test" ]]; then
        echo "Unknwon release_type. Known: stable,test. Default: test"
        exit 0
    fi
}


function get_bin_name {
    local name
    name=$(grep 'SANDBOX_TASK' "${TARGET}"/bin/ya.make | sed 's/SANDBOX_TASK(\(.*\))$/\1/g')
    echo "${name}"
}


if [ -z "${TASK}" ] || [ -z "${TARGET}" ]; then usage; fi
check

bin_task=$(get_bin_name)
echo "Building ${bin_task}"
${YA} make "${TARGET}"/bin
echo -n "Checking ${TASK} in list-types... "

set +e
"${TARGET}"/bin/"${bin_task}" content --list-types | grep "\"${TASK}\"" >/dev/null 2>&1 ; ec=$?
set -e

if [[ ${ec} -eq 0 ]]; then
    echo "Found"
    echo "Uploading with attrs: target=${TARGET_PREFIX}/${TARGET} release=${RELEASE_TYPE}"
    "${TARGET}"/bin/"${bin_task}" upload --attr target="${TARGET_PREFIX}/${TARGET}" \
        --attr release="${RELEASE_TYPE}" --attr ttl=inf --force
else
    echo "Not found"
    echo "No corresponding content type ${TASK} in list-types output"
    "${TARGET}"/bin/"${bin_task}" content --list-types
    exit 1
fi
