# -*- coding: utf-8 -*-

"""
    DESCRIPTION: Sandbox task for pushing json spec to Yandex Deploy
    AUTHOR: @coldmind
    ST_QUEUE: CADMIN
"""


import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm

import logging

from sandbox import common
from sandbox import sdk2
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.media.utils.secret_helper import SecretHelper


class DctlPutStageParameters(sdk2.Parameters):
    container = sdk2.parameters.Container('Container', required=True,
                                          platform='linux_ubuntu_18.04_bionic')

    with sdk2.parameters.Group('Jsonnet to deploy parameters') as group_parameters:
        spec_resource_id = sdk2.parameters.Resource(
            'Resource to do dctl put stage on',
            description='Resource ID of json/yaml spec to put to deploy',
            required=True
        )

        env_secrets = sdk2.parameters.Dict(
            'Secrets for environment',
            default={'sec-01e0cwyhrya60z5qm49pyqxbgk@dctl_token': 'DCTL_YP_TOKEN'},
            description='These secrets are from your robot! E.g. robot-kp-java. This is needed for task.'
                        'Map YAV secret [ID@key] to environment variable name. '
                        '*YAV secret must be delegated to Sandbox*. '
                        'E.g.: sec-xxxx@myval = MYTOKEN',
        )


class DctlPutStage(sdk2.Task):
    name_for_humans = 'Get json/yaml deploy spec from resource and deploy stage to deploy.'
    Parameters = DctlPutStageParameters

    class Requirements(sdk2.Task.Requirements):
        # privileged = True
        dns = ctm.DnsType.DNS64
        client_tags = ctc.Tag.LINUX_BIONIC
        cores = 1
        ram = 1  # 1GiB

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    def on_execute(self):
        SecretHelper.initialize_secrets(self.Parameters.env_secrets)

        # Get dctl binary.
        #
        dctl_binary = sdk2.Resource.find(id='2607692930').first()
        if not dctl_binary:
            raise common.errors.TaskFailure('Could not find dctl binary')

        spec = sdk2.Resource[self.Parameters.spec_resource_id]

        fs_path_dctl = str(sdk2.ResourceData(dctl_binary).path)
        fs_path_spec = str(sdk2.ResourceData(spec).path)

        run_process([fs_path_dctl, 'put', 'stage', fs_path_spec, '--rewrite-delegation-tokens'])

        logging.info('Find your stage and view progress here: https://deploy.yandex-team.ru')


# EOF
