# -*- coding: utf-8 -*-

"""
    DESCRIPTION: Sandbox task for build deploy scripts for Y.D.
    AUTHOR: @coldmind
    ST_QUEUE: CADMIN
"""

import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm

from sandbox import sdk2
from sandbox.projects.media.resources import KpFrontYaDeployDeployScripts
from sandbox.sandboxsdk.svn import Arcadia


class MakeKpFrontYaDeployScriptsParameters(sdk2.Parameters):
    container = sdk2.parameters.Container('Container', required=True,
                                          platform='linux_ubuntu_16.04_xenial')
    with sdk2.parameters.Group('Kp front deploy scripts parameters') as kp_front_bundle:
        arc_url = sdk2.parameters.String(
            'Path inside arcadia after /arc/trunk/arcadia/ with deploy scripts',
            default_value='kinopoisk/sre/deploy/deploy_scripts',
            required=True
        )
        nginx_configs = sdk2.parameters.Resource(
            'kp-front nginx configs bundle. choose released resources like KP_FRONT_CONFIGS_***',
            required=True
        )


class MakeKpFrontYaDeployScripts(sdk2.Task):
    name_for_humans = 'Build resource release for kp-front in Y.D.'
    Parameters = MakeKpFrontYaDeployScriptsParameters

    class Requirements(sdk2.Task.Requirements):
        # privileged = True
        dns = ctm.DnsType.DNS64
        client_tags = ctc.Tag.LINUX_XENIAL

    def on_execute(self):
        self.checkout_scripts()
        self.sanity()
        self.set_resource_id()
        self.create_resources()

    def _arcadia_checkout(self, path, dstdir, revision=None):
        """
        Checkout 'path' from Arcadia to 'dstdir'
        :param str path: path inside arcadia after /arc/trunk/arcadia/
        :param str dstdir: checkout dst dir name
        :param str|String revision: svn revision number, if None revision is taken from svn.info
        :return str revision: Checked out revision id
        """
        url = Arcadia.trunk_url(path, revision)
        if not revision:
            revision = Arcadia.info(url)["entry_revision"]
        Arcadia.checkout(url, dstdir, revision=revision)
        return revision

    def checkout_scripts(self):
        self.Context.scripts_path = 'deploy_scripts'
        self._arcadia_checkout(self.Parameters.arc_url, self.Context.scripts_path)

    def sanity(self):
        """
            Basic shell check
        """
        pass

    def set_resource_id(self):
        """
            Sets resource id to be downloaded on init stage
        """
        lines = ''
        with open('{}/init.sh'.format(self.Context.scripts_path), 'r') as __fd__:
            lines = ''.join(__fd__.read())
        lines = lines.replace('__id__', str(self.Parameters.nginx_configs.id))
        with open('{}/init.sh'.format(self.Context.scripts_path), 'w') as __fd__:
            __fd__.write(lines)

    def create_resources(self, path=None):
        """
            Create resource bundle with scripts and publish it
        """
        _desc_ = '{} build from {}'.format(
            self.name_for_humans,
            self.Parameters.arc_url
        )
        KpFrontYaDeployDeployScripts(self, _desc_, self.Context.scripts_path)

# EOF
