"""
    Custom resource types for using in mediaadmins' projects.
"""
import os

from sandbox import sdk2
from sandbox.sandboxsdk.environments import SandboxEnvironment


class KpFrontNginxBinary(sdk2.Resource):
    """
        Archived bundle for kp-front.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontConfigsTesting(sdk2.Resource):
    """
        Archived bundle for kp-front.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontConfigsLoad(sdk2.Resource):
    """
        Archived bundle for kp-front.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontConfigsDevelopment(sdk2.Resource):
    """
        Archived bundle for kp-front.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontConfigsPrestable(sdk2.Resource):
    """
        Archived bundle for kp-front.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontConfigsProduction(sdk2.Resource):
    """
        Archived bundle for kp-front.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontConfigsUnstable(sdk2.Resource):
    """
        Archived bundle for kp-front.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class PortoLayerUbuntuXenialMediaAdmin(sdk2.Resource):
    """
        Resource for top porto layer for rtc kp projects.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class PortoLayerUbuntuBionicKinopoisk(sdk2.Resource):
    """
        Resource for top porto layer for rtc kp projects.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class PortoLayerUbuntuBionicJavaKinopoisk(sdk2.Resource):
    """
        Resource for top porto layer for rtc kp projects.
        Java jdk and some java dependacies.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class PortoLayerUbuntuXenialKpJavaBackend(sdk2.Resource):
    """
        Resource for top porto layer for rtc kp projects.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontYaDeployDeployScripts(sdk2.Resource):
    """
        Archived deploy scripts for kp-front in YD
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class KpFrontRTCDeployScripts(sdk2.Resource):
    """
        Archived deploy scripts for kp-front in RTC
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['coldmind', 'chrono', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class JupyResource(sdk2.Resource):
    """
        Resource contains jupycli binary
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['chrono', 'coldmind', 'gibzer', 'sergeyv', 'vyacheslav', 'MEDIAADMIN']


class JupyEnvironment(SandboxEnvironment):
    """
        Get JUPY_RESOURCE
        Return jupycli path
    """
    name = 'jupycli'
    path = None
    resource_type = 'JUPY_RESOURCE'
    platform = 'ubuntu_amd64'
    sys_path_utils = ["jupycli"]

    def prepare(self):
        binary_path = self.get_environment_resource()
        self.update_os_path_env(os.path.dirname(binary_path))
        self.check_environment()
        self.path = binary_path
        return binary_path


class MediaJugglerCalls(sdk2.Resource):
    """
        Resource for MediaJugglerReport
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['vyacheslav', 'gibzer', 'coldmind', 'sergeyv', 'MEDIAADMIN']


class KpSreDocker(sdk2.Resource):
    """
        Resource for kp ci
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['vyacheslav', 'gibzer', 'coldmind', 'sergeyv', 'MEDIAADMIN']


class AWACS_STAGE_INSERTER(sdk2.Resource):
    """
        Resource for kp ci
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['vyacheslav', 'gibzer', 'coldmind', 'sergeyv', 'MEDIAADMIN', 'KINOPOISK', 'OTT']


class JSON_RESOURCE(sdk2.Resource):
    """
        Resource for kp+ott ci
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['MEDIAADMIN', 'KINOPOISK', 'OTT']
