import os

from sandbox import sdk2
from sandbox.projects.common.arcadia import sdk as arcadia_sdk
from sandbox.projects.media.utils.secret_helper import SecretHelper


class RunInArcadiaWithOutput(sdk2.Task):
    class Requirements(sdk2.Requirements):
        cores = 1
        ram = 1  # 1GiB

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl(
            'arcadia url',
            required=True
        )
        cmd_str = sdk2.parameters.String(
            'cmd with args',
            description='cmd with arguments to run',
            required=True
        )
        output_resource_type = sdk2.parameters.String(
            'output resource type',
            default='PLAIN_TEXT'
        )
        output_resource_name = sdk2.parameters.String(
            'output resource name',
            default='output.txt'
        )
        env_secrets = sdk2.parameters.Dict(
            'Optional secrets',
            description='These secrets are from your robot! E.g. robot-kp-java. This is needed for task.'
                        'Map YAV secret [ID@key] to environment variable name. '
                        '*YAV secret must be delegated to Sandbox*. '
                        'E.g.: sec-xxxx@myval = MYTOKEN',
        )
        resource_mappings = sdk2.parameters.Dict(
            'Optional resource to placeholders mappings',
            description='Resources in format RESOURCE_ID = PLACEHOLDER_ID '
                        'Will be downloaded to some cached dir in fs. '
                        'The corresponding placeholders in run command (format: $$PLACEHOLDER_ID$$)'
                        ' will be replaced to the path. '
                        'E.g. {100500: MY_RESOURCE}, and cmd_str="echo $$MY_RESOURCE$$/myfile.txt"',
        )

    def on_execute(self):
        with arcadia_sdk.mount_arc_path(self.Parameters.checkout_arcadia_from_url) as path_arc:
            SecretHelper.initialize_secrets(self.Parameters.env_secrets)

            cmd_str = self.Parameters.cmd_str

            for resource_id, placeholder in self.Parameters.resource_mappings.items():
                resource = sdk2.Resource[int(resource_id)]
                data = sdk2.ResourceData(resource)
                cmd_str = cmd_str.replace('$$' + placeholder + '$$', str(data.path))

            os.chdir(path_arc)

            resource = sdk2.Resource[self.Parameters.output_resource_type](self, "Output", self.Parameters.output_resource_name)
            data = sdk2.ResourceData(resource)

            sdk2.helpers.subprocess.check_call('{} > {}'.format(cmd_str, str(data.path)), shell=True)

            data.ready()
