import logging
import json

from sandbox.sdk2.helpers import process
from sandbox.projects.common.vcs import arc


def arc_list_branches(mount_point, prefix):
    logging.info("getting branches")
    try:
        out = process.subprocess.check_output([arc.Arc()._client_bin, "branch", "--all", "--json"],
                                              cwd=mount_point)
        return [x['name'] for x in json.loads(out.strip()) if prefix is None or x['name'].startswith(prefix)]
    except process.subprocess.CalledProcessError as e:
        logging.error(str(e))
        raise arc.ArcCommandFailed("unable to list branches")


def arc_create_remote_branch(mount_point, branch_name):
    arc.Arc().checkout(mount_point, branch=branch_name, create_branch=True)
    arc.Arc().push(mount_point, branch_name)


def arc_delete_remote_branch(mount_point, branch_name):
    logging.info("deleting branch %s" % branch_name)
    try:
        command = [arc.Arc()._client_bin, "push", "-d", branch_name]
        process.subprocess.check_call(command, cwd=mount_point)
    except process.subprocess.CalledProcessError as e:
        logging.error(str(e))
        raise arc.ArcCommandFailed("unable to delete branch %s" % branch_name)


def arc_get_revision_info(mount_point, revisions):
    logging.info("getting revision info")
    try:
        str_revisions = ['r{}'.format(x) for x in revisions]
        out = process.subprocess.check_output(
            [arc.Arc()._client_bin, "show", "--name-only", "--json"] + str_revisions, cwd=mount_point)
        result = []
        for item in json.loads(out.strip()):
            commit = item['commits'][0]
            result.append({
                'author': commit['author'],
                'date': commit['date'],
                'revision': commit['revision'],
                'message': commit['message'],
            })
        return result
    except process.subprocess.CalledProcessError as e:
        logging.error(str(e))
        raise arc.ArcCommandFailed("unable to get revision info")
