from sandbox import sdk2
from sandbox.projects.mediaanalyst.libs.common.base import MaSandboxBaseTask
from sandbox.common.types import misc as ctm


class MaChCleanup(MaSandboxBaseTask):
    BINARY_TASK_ATTR_TARGET = "mediaanalyst/tasks/MaChCleanup"

    class Parameters(MaSandboxBaseTask.Parameters):
        config = sdk2.parameters.String("Configuration arc path", required=True)
        mdb_token = sdk2.parameters.YavSecret("Mdb token", required=True)
        clickhouse_user = sdk2.parameters.String("Clickhouse user", required=True)
        clickhouse_password = sdk2.parameters.YavSecret("Clickhouse password", required=True)
        dry_run = sdk2.parameters.Bool("Dry run", required=True, default=True)

    def on_enqueue(self):
        self.Requirements.dns = ctm.DnsType.DNS64

    def on_execute(self):
        pass
