# coding: utf-8
import logging
import sandbox.sdk2 as sdk2
from sandbox.projects.mediaanalyst.libs.common.base import MaSandboxBaseTask


class MaTableauRefreshExtract(MaSandboxBaseTask):
    BINARY_TASK_ATTR_TARGET = "mediaanalyst/tasks/MaTableauRefreshExtract"
    server_url = "https://tableau.media.yandex.net"

    class Parameters(MaSandboxBaseTask.Parameters):
        with sdk2.parameters.Group("Main settings", collapse=True) as main_settings_block:
            workbook_name = sdk2.parameters.String("Workbook name", required=True)
            username = sdk2.parameters.String("Tableau user", required=True)
            password = sdk2.parameters.YavSecret("Tableau password for user", required=True)

    def on_execute(self):
        import tableauserverclient
        password = self.Parameters.password.data()["password"]
        tableau_auth = tableauserverclient.TableauAuth(self.Parameters.username, password)
        server = tableauserverclient.Server(self.server_url)
        server.add_http_options({"verify": False})
        server.use_highest_version()

        with server.auth.sign_in(tableau_auth):
            req_option = tableauserverclient.RequestOptions()
            req_option.filter.add(tableauserverclient.Filter(tableauserverclient.RequestOptions.Field.Name,
                                                             tableauserverclient.RequestOptions.Operator.Equals,
                                                             self.Parameters.workbook_name))
            matching_workbooks, pagination_item = server.workbooks.get(req_option)
            logging.info('matched workbooks: %d' % len(matching_workbooks))

            for wb in matching_workbooks:
                logging.info("workbook: %s id: %s project: %s %s bytes" % (wb.name, wb.id, wb.project_name, wb.size))
                logging.info("refreshing data sources")
                job = server.workbooks.refresh(wb)
                logging.info("extract triggered for workbook %s job id: %s" % (wb.name, job.id))
                logging.info("success")
