from sandbox import sdk2
from sandbox.projects.mediaanalyst.libs.common.base import MaSandboxBaseTask


class MaYtToChMonitoring(MaSandboxBaseTask):

    BINARY_TASK_ATTR_TARGET = "mediaanalyst/tasks/MaYtToChMonitoring"

    class Parameters(MaSandboxBaseTask.Parameters):

        with sdk2.parameters.Group("Solomon settings", collapse=True) as solomon_settings:
            project = sdk2.parameters.String(
                "Solomon project",
                required=True,
            )

            service = sdk2.parameters.String(
                "Solomon service",
                required=True,
            )

            cluster = sdk2.parameters.String(
                "Solomon cluster",
                required=True,
            )

        with sdk2.parameters.Group("Other settings", collapse=True) as other_settings:
            oauth_token = sdk2.parameters.YavSecret("OAuth token", required=True)

    def on_execute(self):
        pass
