# Mediabilling sandbox
Каталог sanbox бинарных задач Медиабиллинга
Просьба писать только бинарные задачи

## Бинарные задачи
### Описание
Документация доступна [здесь](https://docs.yandex-team.ru/sandbox/dev/binary-task)

### Сделать задачу бинарной
В документации по пунктам описано, как это сделать. Тем не менее можно воспользоваться наглядным примером в виде [PR по переводу первой нашей задачи в бинарный тип](https://a.yandex-team.ru/review/2403219/details)
В кратце:
* Задача должна в том числе наследоваться от `sandbox.projects.common.binary_task.LastBinaryTaskRelease`
* В параметрах задачи должна быть переменная `binary_release = binary_task.binary_release_parameters(stable=True)`
* `.on_execute()`, `on_save()` методы должны начинаться с вызова родительского `super().on_execute()` `super().on_save()`
* В `ya.make` вместо объявления `PYN_LIBRARY` должен быть `SANDBOX_TASK`
* В `ya.make` должны быть прописаны все зависимости по коду в секции `PEERDIR()`
* Все зависимости вне директории `sandbox` должны подключаться в обработчиках событий - например `on_execute` (кроме `on_create`, `on_save`, `on_enqueue`)

### CI/CD для бинарных задач
#### Настройка
В директории с задачей добавить a.yaml с описанием флоу. Подготовлен [a.example.yaml](https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/projects/mediabilling/a.example.yaml) шаблон,
который достаточно скопировать и заменить в нем `change_me` вхождения на нужное. Пример значений можно посмотреть в директории с конкретной задачей

После коммита a.yaml надо будет делегировать токен робота для этого конфига

В [проекте Mediabilling CI в секции Sandbox](https://a.yandex-team.ru/projects/mediabilling/ci) появится секция с вашей задачей

#### Управление
* На PR запускается билд и релиз с аттрибутом `unstable`. В Sandbox у задачи можно будет выбрать этот аттрибут и протестировать задачу
* Билд и релиз с аттрибутом `testing` запускается автоматически на мерж в `trunk`
* Релиз в продакшн (смена значения аттрибута релиза с `testing` на `stable`) запускается руками во флоу релиза по кнопке `Play`
* Если у задачи выставлен `binary_release = ...(stable=True)` - то по умолчанию она будет подгружать последний стабильный релиз бинаря. Что нам и надо
* Бывает полезно прокинуть параметр `binary_release` в параметры запуска дочерних задач, чтобы можно было запустить всю цепочку в нужном окружении
