import os

import sandbox.sdk2 as sdk2
from sandbox.projects.common import binary_task

from sandbox.projects.mediabilling.deploy.util import MBCONFIG, TaskHelper, BuildHelper


class MediabillingBuildJars(binary_task.LastBinaryTaskRelease, TaskHelper):
    """ Build Mediabilling Jars based on the revision number """
    fail_on_any_error = True
    BUILD_DIR = 'build'
    OUT_DIR = 'out'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 75 * 1024  # in megabytes

    class Parameters(sdk2.Task.Parameters):
        binary_release = binary_task.binary_release_parameters(stable=True)
        kill_timeout = 80 * 60
        description = "Build Yandex.Mediabilling JARs and configs"

        url = sdk2.parameters.String("The arcadia url",
                                     description=MBCONFIG.arcadia_description,
                                     required=True)

        patch = sdk2.parameters.String("The patch file to apply")
        patch_over_revision = sdk2.parameters.Integer("The patch is from this revision")

        if MBCONFIG.is_dev:
            local_arcadia_path = sdk2.parameters.String("The local arcadia path",
                                                        default=os.path.expanduser("~/arcadia-tmp"))

        with sdk2.parameters.Output():
            branch = sdk2.parameters.String("The branch built from")
            revision = sdk2.parameters.Integer("The revision built from")

    def on_execute(self):
        super(MediabillingBuildJars, self).on_execute()
        secret = sdk2.yav.Secret(MBCONFIG.yav_token)
        arcanum_token = secret.data()[MBCONFIG.arcanum_token_name]
        yt_token = secret.data()[MBCONFIG.yt_token_name]

        bh = BuildHelper(patch=str(self.Parameters.patch),
                         local_arcadia_path=str(self.Parameters.local_arcadia_path) if MBCONFIG.is_dev else None,
                         set_info=self.set_info,
                         arcanum_token=arcanum_token)

        bh.run(self,
               str(self.Parameters.url),
               yt_token)

        self.Parameters.branch = bh.branch
        self.Parameters.revision = bh.revision

        self.set_info('Revision: <b>{}</b><br/>Branch: <b>{}</b>'
                      .format(self.Parameters.revision, self.Parameters.branch),
                      do_escape=False)
        self.hint('{}/{}/{}'.format(self.Parameters.branch, self.Parameters.revision, self.Parameters.patch))
