# coding: utf-8

import sandbox.common.types.task as ctt
import sandbox.sdk2 as sdk2
from sandbox.projects.common import binary_task

from sandbox.projects.mediabilling.deploy.MediabillingStartDeployment import MediabillingStartDeployment
from sandbox.projects.mediabilling.deploy.util import MBCONFIG, Deployment, TaskHelper


class MediabillingRegularCheck(binary_task.LastBinaryTaskRelease, TaskHelper):
    """ The regular cron maintenance task for Mediabilling deployment """

    class Requirements(sdk2.Task.Requirements):
        environments = [TaskHelper.startrek_client_environment]
        cores = 1

        semaphores = ctt.Semaphores(
            acquires=[
                ctt.Semaphores.Acquire(name="mediabilling_deployment")
            ],
            release=(ctt.Status.Group.BREAK, ctt.Status.Group.FINISH)
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        binary_release = binary_task.binary_release_parameters(stable=True)
        kill_timeout = 10 * 60
        description = "Regularly maintain deployment for Mediabilling"
        is_manual = sdk2.parameters.Bool("Is manual", required=True)

    def new_release_task(self, url):
        return MediabillingStartDeployment(self,
                                           binary_release=self.Parameters.binary_executor_release_type,
                                           mode='standard',
                                           force_create_branch=False,
                                           standard_url=url,
                                           notifications=self.Parameters.notifications)

    def deploy_to_stable_task(self, task):
        return MediabillingStartDeployment(self,
                                           binary_release=self.Parameters.binary_executor_release_type,
                                           mode='stable',
                                           stable_task=task,
                                           notifications=self.Parameters.notifications)

    def on_execute(self):
        super(MediabillingRegularCheck, self).on_execute()
        secret = sdk2.yav.Secret(MBCONFIG.yav_token)
        oauth_token = secret.data()[MBCONFIG.token_name]
        self.check_authorization(self.author, oauth_token, MBCONFIG.auth_build)

        deployment = Deployment()
        deployment.cron(is_manual=self.Parameters.is_manual,
                        new_release_task=self.new_release_task,
                        deploy_to_stable_task=self.deploy_to_stable_task,
                        token=oauth_token)
