# coding: utf-8
import socket


class cached_property(object):
    def __init__(self, func):
        self.func = func

    def __get__(self, obj, cls):
        if obj is None:
            return self

        value = obj.__dict__[self.func.__name__] = self.func(obj)
        return value


class Config(object):
    yav_token = 'sec-01e0r2m2znx2nqqvv2ygnfdxy4'
    token_name = 'ROBOT_MEDIABILLING_OAUTH'

    yt_token_name = 'ROBOT_MEDIABILLING_YT_TOKEN'
    arcanum_token_name = 'ROBOT_MEDIABILLING_ARCANUM_TOKEN'
    tanker_token_name = 'ROBOT_MEDIABILLING_TANKER_TOKEN'

    deployer_username = 'robot-mi-deploy'

    mbduty_created_in_last_24h_filter_id = 410134
    mbduty_resolved_in_last_24h_filter_id = 410133
    mbduty_total_unresolved_filter_id = 410135
    mbduty_older_then_7d_filter_id = 410139

    auth_build = {
        'logins': ('alexbool', 'paulus'),
        'include': ('svc_mediabilling_administration',),
        'exclude': ('svc_mediabilling_testing',),  # SOX rule: testers cannot issue a build
    }

    build_jars_task_type = 'MEDIABILLING_BUILD_JARS'

    queue = 'MBRELEASES'

    @cached_property
    def is_dev(self):
        host = socket.gethostname()
        return host.endswith('sv.vla.yp-c.yandex.net')

    arcadia_trunk = 'arcadia:/arc/trunk/arcadia'
    arcadia_branch = 'arcadia:/arc/branches/mediabilling/common/stable-{}/arcadia'
    arc_url = 'https://a.yandex-team.ru/arc/commit/{}'

    # See duty schedules here https://abc.yandex-team.ru/services/mediabilling/duty/
    abc_schedule_slag_backend = 'mbduty'
    abc_schedule_slag_qa = 'mbduty_qa'
    abc_duty_url = 'https://abc-back.yandex-team.ru/api/v4/services/2411/on_duty/?schedule__slug={}'

    ci_project_id = 1129
    ci_toolchain = 'default-linux-x86_64-relwithdebinfo'
    ci_max_revisions = 500

    release_timeouts = {
        'testing': 60 * 60,  # 1h
        'stable': 60 * 90,  # 1.5h
        'hotfix': 60 * 90,  # 1.5h
    }

    working_days = {
        'from': 0,  # monday
        'to': 4,  # friday
    }

    working_hours = {
        'from': 10,
        'to': 19,
    }

    new_branch_hours = {
        'from': 6,
        'to': 10,
    }

    list_prefix = u'    • '
    nanny_api_url = 'https://nanny.yandex-team.ru'

    debug_mediabilling_status_chat_id = -496471066
    debug_mediabilling_support_chat_id = -496471066
    mediabilling_status_chat_id = -1001285886867
    mediabilling_support_chat_id = -1001207712398
    mediabilling_releases_chat_id = -707522430

    checklist = [
        "Проверить номер ревизии в z-админке (номера должны совпадать с ревизией релиза)",
        "Проверить, что все задачи в релизе протестированы на PR",
        "Провести внутренний регресс"
    ]

    @cached_property
    def deployment_tests(self):
        # delayed loading to work around the resolve loop
        from sandbox.projects.mediabilling.deploy.MediabillingReleaseTests import MediabillingReleaseTests
        from sandbox.projects.mediabilling.deploy.MediabillingSwaggerCoverageReport import \
            MediabillingSwaggerCoverageReport

        return [
            MediabillingSwaggerCoverageReport,
            MediabillingReleaseTests,
        ]

    @cached_property
    def components_non_sox(self):
        return tuple(set(self.components) - set(self.components_sox))

    @cached_property
    def arcadia_trunk_mediabilling(self):
        return self.arcadia_trunk + '/media-billing'

    def arcadia_trunk_revision(self, revision):
        return '{}@{}'.format(self.arcadia_trunk, revision)

    def arcadia_branch_revision(self, branch, revision):
        return 'arcadia:/arc/branches/mediabilling/common/{}/arcadia@{}'.format(branch, revision)

    @property
    def arcadia_description(self):
        rev = '[@revision]'
        return self.arcadia_trunk + rev + '<br/>' + self.arcadia_branch.format('XXX') + rev

    @staticmethod
    def markdown_startrek(key):
        return u'[{0}](https://st.yandex-team.ru/{0})'.format(key)

    @staticmethod
    def markdown_startrek_filter(text, filter_id):
        return u'[{0}](https://st.yandex-team.ru/issues/{1})'.format(text, filter_id)

    @staticmethod
    def markdown_staff(login, name):
        return u'[{0}](https://staff.yandex-team.ru/{1})'.format(name, login)

    @staticmethod
    def markdown_sandbox(task_id):
        return u'[{0}](https://sandbox.yandex-team.ru/task/{0})'.format(task_id)

    def arc_commit_url(self, revision):
        return self.arc_url.format(revision)

    @staticmethod
    def deployment_url(dashboard, deployment):
        url = u'https://nanny.yandex-team.ru/ui/#/services/dashboards/catalog/{0}/deployments/catalog/{1}/'
        return url.format(dashboard, deployment)

    def markdown_deployment(self, dashboard, deployment):
        return u'[{}]('.format(dashboard) + self.deployment_url(dashboard, deployment) + u')'

    @cached_property
    def nyan_url(self):
        return 'https://api.nbt.media.yandex.net/v2'

    @cached_property
    def dashboards(self):
        return ['music-connector']

    @cached_property
    def dockers(self):
        return {
            'yd-api': {
                'path': 'mediabilling/yandex-mediabilling-api:',
                'config': 'media-billing/bootstrap/docker/mb-api/package.json'
            },
            'yd-admin': {
                'path': 'mediabilling/yandex-mediabilling-admin:',
                'config': 'media-billing/bootstrap/docker/mb-admin/package.json'
            },
            'yd-promotion-offers': {
                'path': 'mediabilling/yandex-mediabilling-promotion-offers-app:',
                'config': 'media-billing/bootstrap/docker/promotion-offers/package.json'
            },
            'yd-promotion-offers-admin': {
                'path': 'mediabilling/yandex-mediabilling-promotion-offers-admin:',
                'config': 'media-billing/bootstrap/docker/promotion-offers-admin/package.json'
            },
            'yd-external-api': {
                'path': 'mediabilling/yandex-mediabilling-external-api-deploy:',
                'config': 'media-billing/bootstrap/docker/external-api/package.json'
            },
            'yd-gw': {
                'path': 'mediabilling/yandex-mediabilling-gw:',
                'config': 'media-billing/bootstrap/docker/mb-gw/package.json'
            },
            'yd-connectors': {
                'path': 'mediabilling/yandex-mediabilling-connectors:',
                'config': 'media-billing/bootstrap/docker/mb-connectors/package.json'
            },
            'yd-fast-prices': {
                'path': 'mediabilling/yandex-mediabilling-fast-prices-deploy:',
                'config': 'media-billing/bootstrap/docker/fast-prices/package.json'
            },
            'yd-worker': {
                'path': 'mediabilling/yandex-mediabilling-worker:',
                'config': 'media-billing/bootstrap/docker/mb-worker/package.json'
            }
        }

    @cached_property
    def yd_services(self):
        return {
            'yd-api': {
                'deploy-testing': ['media-billing.internal-api.testing'],
                'deploy-prod': ['media-billing.internal-api.production']
            },
            'yd-admin': {
                'deploy-testing': ['media-billing.admin.testing'],
                'deploy-prod': ['media-billing.admin.production']
            },
            'yd-promotion-offers': {
                'deploy-testing': ['media-billing.promotion-offers.testing'],
                'deploy-prod': ['media-billing.promotion-offers.production']
            },
            'yd-promotion-offers-admin': {
                'deploy-testing': ['media-billing.promotion-offers-admin.testing'],
                'deploy-prod': ['media-billing.promotion-offers-admin.production']
            },
            'yd-external-api': {
                'deploy-testing': ['media-billing.external-api.testing'],
                'deploy-prod': ['media-billing.external-api.production']
            },
            'yd-gw': {
                'deploy-testing': ['media-billing.gw.testing'],
                'deploy-prod': ['media-billing.gw.production']
            },
            'yd-connectors': {
                'deploy-testing': ['media-billing.connectors.testing'],
                'deploy-prod': ['media-billing.connectors.production']
            },
            'yd-fast-prices': {
                'deploy-testing': ['media-billing.fast-prices.testing'],
                'deploy-prod': ['media-billing.fast-prices.production']
            },
            'yd-worker': {
                'deploy-testing': ['media-billing.worker-lite.testing', 'media-billing.bazinga-controller.testing'],
                'deploy-prod': ['media-billing.worker-lite.production', 'media-billing.bazinga-controller.production']
            }
        }

    @staticmethod
    def wikiformat_sandbox(task_id):
        return '((https://sandbox.yandex-team.ru/task/{0} {0}))'.format(task_id)

    @staticmethod
    def issue_summary(revision, branch):
        return u'Медиабиллинг. Релиз. Ревизия {} ({})'.format(revision, branch)


MBCONFIG = Config()
