# coding: utf-8
import logging
from urlparse import urljoin

import requests

from sandbox.projects.music.deployment.helpers.DashboardUpdater import DashboardUpdater

NANNY_URL = 'http://nanny.yandex-team.ru/'


class NannyDockerUpdater(object):

    def updateDocker(
        self,
        oauth_token,
        dashboard,
        recipe_name,
        image,
        comment
    ):
        updater = DashboardUpdater(oauth_token)
        services = updater.recipe_to_services(dashboard, recipe_name)
        self.update_service(oauth_token, comment, image, services)

    def update_service(
        self,
        oauth_token,
        comment,
        image,
        services
    ):
        session = requests.Session()
        session.headers['Authorization'] = 'OAuth {}'.format(oauth_token)
        for s_id in services:
            runtime_attrs_url = urljoin(NANNY_URL, 'v2/services/{}/runtime_attrs/'.format(s_id))
            resp = session.get(runtime_attrs_url)
            resp.raise_for_status()
            runtime_attrs = resp.json()
            logging.info(runtime_attrs)

            snapshot_id = runtime_attrs['_id']
            content = runtime_attrs['content']
            dockerImage = content['instance_spec']['dockerImage']
            logging.info(dockerImage)
            dockerImage['name'] = image
            logging.info(dockerImage)

            r = session.put(runtime_attrs_url, json={
                'snapshot_id': snapshot_id,
                'content': content,
                'comment': comment,
            })
            print(r.status_code)
            r.raise_for_status()
