import logging
import requests

import sandbox.sdk2 as sdk2
from sandbox.common import errors
from sandbox.projects.common import binary_task

from sandbox.projects.mediabilling.deploy.util import MBCONFIG

FILENAME = 'translations.tjson'

IMPORT_URL = 'https://tanker-api.test.yandex-team.ru/keysets/replace/'
EXPORT_URL = 'https://tanker-api.yandex-team.ru/projects/export/tjson/?project-id=mediabilling&keyset-id=Payment_Widget'


class MediabillingCopyKeySet(binary_task.LastBinaryTaskRelease, sdk2.Task):
    """ Copy tanker keyset production->testing """

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        binary_release = binary_task.binary_release_parameters(stable=True)
        kill_timeout = 5 * 60
        description = "Downloads translations from production tanker and uploads to testing"

    def on_execute(self):
        super(MediabillingCopyKeySet, self).on_execute()
        secret = sdk2.yav.Secret(MBCONFIG.yav_token)
        token = secret.data()[MBCONFIG.tanker_token_name]

        translations = requests.get(EXPORT_URL).text

        with open(FILENAME, 'w') as file:
            file.write(translations)

        with open(FILENAME, 'rb') as file:
            result = requests.post(IMPORT_URL,
                                   headers={'Authorization': 'OAuth {}'.format(token), 'Expect': ''},
                                   data={'keyset-id': 'Payment_Widget', 'project-id': 'Payment_Widget_Testing', 'format': 'tjson', 'force-replace': '1'},
                                   files={'file': file})

        if result.status_code != 200:
            raise errors.TaskFailure('Failed to upload translations, status={}: {}'.format(result.status_code, result.text))

        logging.info('Upload response: %s', result.text)
