import json

from bson import json_util

import util


def raw_bson(value):
    bson_string = json_util.dumps(value, json_options=json_util.RELAXED_JSON_OPTIONS)
    bson_dict = json.loads(bson_string)
    return _alter_keys(bson_dict, _escape_leading_dollar_sign)


def msk_millis(value):
    return util.msk_millis(value)


def _escape_leading_dollar_sign(name, escape_with="$"):
    return escape_with + name if name.startswith("$") else name


def _alter_keys(entry, key_mapper):
    if isinstance(entry, dict):
        return {key_mapper(k): _alter_keys(v, key_mapper) for k, v in entry.items()}
    if isinstance(entry, list):
        return [_alter_keys(v, key_mapper) for v in entry]
    return entry
