import time
from datetime import datetime

import sandbox.sdk2 as sdk2
import yaml

ROBOT_TOKEN_SECRET = "sec-01e0r2m2znx2nqqvv2ygnfdxy4"
ARCADIA_TOKEN_KEY = "ROBOT_MEDIABILLING_OAUTH"
YT_TOKEN_KEY = 'ROBOT_MEDIABILLING_YT_TOKEN'


def load_yaml(filename):
    with open(filename, "r") as f:
        return yaml.safe_load(f)


# must be replaced with int(dt.timestamp() * 1000) after migration to python3
def msk_millis(dt):
    naive = dt.replace(tzinfo=None)
    return int(time.mktime(naive.timetuple()) * 1000 + naive.microsecond / 1000)


def unix_time_millis(dt):
    naive = dt.replace(tzinfo=None)
    epoch = datetime.utcfromtimestamp(0)
    return int((naive - epoch).total_seconds() * 1000.0)


# ugly, replace with x | y in python3
def merge_two_dicts(x, y):
    z = x.copy()
    z.update(y)
    return z


def yt_token():
    return sdk2.yav.Secret(ROBOT_TOKEN_SECRET).data()[YT_TOKEN_KEY]


def wait_process(process):
    return_code = process.wait()
    if return_code:
        raise Exception("Process %s failed with code %s", process, return_code)


def lines_count(file_path):
    return sum(1 for _ in open(file_path))
