""" Settings and constants for release machine """
import sandbox.projects.release_machine.core.const as rm_const


# Startrek options
STARTREK_QUEUE = "MIR"
STARTREK_FOLLOWERS = []

# TestEnv options
TRUNK_TASK_OWNER = "MEDIABILLING"
RM_TESTENV_OWNERS = [
    "aarseniev",
    "maximus",
    "murad-mir",
    "fitialovks",
    "psmcd"
]
COMPONENT_GROUP = "media-billing"

# SB Tasks
TASK_NAMES = {
    "build": "AFISHA_BUILD_DOCKER",
    "release": "AFISHA_RELEASE",
    "release2": "AFISHA_RELEASE_2",
    "pr_release": "AFISHA_PR_RELEASE",
    "pr_register": "AFISHA_PR_REGISTER"
}
RELEASE_RESOURCE = "AFISHA_TICKETS_BACKEND_BINARY"
RESTART_POLICY = (
    {
        "sleep_before_action": 0,
        "default_action": rm_const.RestartPolicyActions.NOOP,
    },
)

IMPORTANT_CHANGES_LIMIT = 1000
