from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
import sandbox.projects.resource_types as rt
import sandbox.projects.mediasearch.resource_types as mrt

from sandbox.projects.common.search import gdb


class BuildLyricsMiddlesearch(YaMakeTemplate.YaMakeTemplate):

    class Requirements(sdk2.Task.Requirements):
        disk_space = 80 * 1024

    class Parameters(YaMakeTemplate.get_project_params(build_resources=[
        mrt.PoetryloverMiddlesearch,
        rt.LOGANALYZE_EXECUTABLE,
        rt.EVLOGDUMP_EXECUTABLE,
        rt.EVLOGCACHEHIT_EXECUTABLE,
        rt.EVLOGSAMPLE_EXECUTABLE,
    ])):
        pass

    def on_execute(self):
        gdb.append_to_stable_only(self)
        super(YaMakeTemplate.YaMakeTemplate, self).on_execute()
