# -*- coding: utf-8 -*-
import os

from sandbox.projects.websearch.begemot.common import add_realtime_version_file
from sandbox.projects.websearch.begemot.resources import BEGEMOT_REALTIME_PACKAGE
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build import parameters as build_params
from sandbox.sandboxsdk import process


class BuildAliceBegemotRealtimePackage(YaMakeTask):

    type = 'BUILD_ALICE_BEGEMOT_REALTIME_PACKAGE'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildSystem,
        build_params.BuildType,
    ]

    _fresh_path = 'search/wizard/data/fresh'
    _tests = [
        'alice/begemot/lib/fixlist_index/ut',
    ]
    _rules = [
        'AliceBinaryIntentClassifier',
        'AliceFixlist',
        'AliceFixlistFilter',
        'AliceParsedFrames',
        'AlicePrepareFrameAggregatorConfig',
        'AliceTrivialTagger',
        'GranetConfig',
    ]

    def initCtx(self):
        YaMakeTask.initCtx(self)
        self.ctx[build_params.TestParameter.name] = True
        self.ctx[build_params.UseArcadiaApiFuse.name] = True

    def get_targets(self):
        return self._tests + ['{}/{}'.format(self._fresh_path, rule) for rule in self._rules]

    def get_arts(self):
        artefacts = []
        for rule in self._rules:
            artefacts.append(
                {
                    'path': '{}/package/{}'.format(self._fresh_path, rule),
                    'dest': 'realtime_wizard_data'
                }
            )
        return artefacts

    def post_build(self, source_dir, output_dir, pack_dir):
        YaMakeTask.post_build(self, source_dir, output_dir, pack_dir)
        self.__create_tar_resource(pack_dir)

    def __create_tar_resource(self, pack_dir):
        archive_file = os.path.abspath('realtime_wizard_data.tar')
        add_realtime_version_file(os.path.join(pack_dir, 'realtime_wizard_data'), self.id, new_binary=True)

        process.run_process(
            ['tar', 'cf', archive_file, '.'],
            log_prefix='tar',
            work_dir='{}/{}'.format(pack_dir, 'realtime_wizard_data')
        )

        resource = self.create_resource(
            description=BEGEMOT_REALTIME_PACKAGE.name + ' for Megamind',
            resource_type=BEGEMOT_REALTIME_PACKAGE,
            resource_path=archive_file,
            attributes={
                'ttl': 31,
                'released': 'stable',
                'shard': 'Megamind',
                'version': self.id,
            }
        )

        self.mark_resource_ready(resource.id)

__Task__ = BuildAliceBegemotRealtimePackage
