# -*- coding: utf-8 -*-

from sandbox import sdk2

assistant_releasers = [
    'dpolukhin',
    'zador',
    'imakunin',
    'putrin',
    'jon2205',
    'petrk',
    'atsepeleva',
    'vi002',
    'robot-bassist',
    'akhruslan',
    'mihajlova',
    'a-sidorin',
    'alkapov'
]


class MEGAMIND_BIN(sdk2.Resource):
    """
        Megamind binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = assistant_releasers


class MEGAMIND_CONFIG(sdk2.Resource):
    """
        Megamind config
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers


class MEGAMIND_FORMULAS(sdk2.Resource):
    """
        Megamind formulas
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers


class BEGEMOT_MEGAMIND_QUERIES(sdk2.Resource):
    """
        Queries for Begemot/Megamind shard
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers


class VINS_PRECLASSIFICATION_MODEL(sdk2.Resource):
    """
        Vins PreClassification model
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers


class PARTIAL_PRECLASSIFICATION_MODEL(sdk2.Resource):
    """
        Partial PreClassification model
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers + ["alex-ersh", "elshiko"]
