from sandbox import sdk2


MELTER_RELEASERS = ['JUPITER']


class MelterResourceBase(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    any_arch = True
    auto_backup = True
    calc_md5 = True
    executable = False
    releasable = True
    releasers = MELTER_RELEASERS
    share = True
    ttl = 100


class MelterWorker(MelterResourceBase):
    """
    Contains pack/melter (melter binary)
    """
    executable = True


class MelterConfigs(MelterResourceBase):
    """
    Contains pack/config (melter related config files).
    """


class MelterGarbageCollector(MelterResourceBase):
    """
    Contains pack/garbage_collector (common Saas 2.0 garbage_collector)
    """
    executable = True


class MelterGarbageCollectorConfigs(MelterResourceBase):
    """
    Contains pack/config (garbage_collector related config files).
    """
