from sandbox.projects.common.nanny.client import NannyClient
from sandbox import sdk2


class DeployNannyDashboardRecipe(sdk2.Task):
    '''
        Deploy some nanny dashboard recipe.
    '''
    NANNY_API_URL = 'http://nanny.yandex-team.ru/'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 1024  # Mb

    class Parameters(sdk2.Task.Parameters):
        dashboard_id = sdk2.parameters.String(
            'Nanny dashboard id', required=True)
        dashboard_recipe_id = sdk2.parameters.String(
            'Nanny dashboard recipe id', required=True)
        nanny_token_vault_id = sdk2.parameters.String(
            'Nanny token sandbox vault item id', required=True)
        nanny_token_vault_owner = sdk2.parameters.String(
            'Nanny token sandbox vault item owner', required=True)

    def on_execute(self):
        nanny_token = sdk2.Vault.data(self.Parameters.nanny_token_vault_owner, self.Parameters.nanny_token_vault_id)
        nanny_client = NannyClient(api_url=self.NANNY_API_URL, oauth_token=nanny_token)
        nanny_client.deploy_dashboard(
            self.Parameters.dashboard_id,
            self.Parameters.dashboard_recipe_id,
            use_latest_snapshot=True
        )
