from sandbox import sdk2


MERCURY_RELEASERS = ['JUPITER']


class MercuryResourceBase(sdk2.Resource):
    __default_attribute__ = sdk2.parameters.String
    any_arch = True
    auto_backup = True
    calc_md5 = True
    executable = False
    releasable = True
    releasers = MERCURY_RELEASERS
    share = True
    ttl = 100


class MercuryBinaries(MercuryResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/mercury/packages/binaries/ya.make
    """
    pass


class MercuryConfigs(MercuryResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/mercury/packages/configs/ya.make
    """
    pass


class MercuryCmpy(MercuryResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/mercury/packages/cmpy/ya.make
    """
    pass


class MercuryShardDeployBundle(MercuryResourceBase):
    """
    See https://a.yandex-team.ru/arc/trunk/arcadia/robot/jupiter/packages/shard_deploy_bundle/ya.make
    """
    pass


class MercuryWorker(MercuryResourceBase):
    """
    Contains pack/worker (worker binary).
    """
    executable = True


class MercuryWorkerConfigs(MercuryResourceBase):
    """
    Contains pack/config (worker config files).
    """
    pass


class MercurySubscriber(MercuryResourceBase):
    """
    Contains pack/subscriber (subscriber binary)
    """
    executable = True


class MercuryShuffler(MercuryResourceBase):
    """
    Contains pack/shuffler (shuffler binary)
    """
    executable = True


class MercuryLogfetcher(MercuryResourceBase):
    """
    Contains pack/subscriber (subscriber binary)
    """
    executable = True


class MercuryRecuperator(MercuryResourceBase):
    """
    Contains pack/recuperator (recuperator binary)
    """
    executable = True


class MercuryStatusScript(MercuryResourceBase):
    """
    Contains nanny status script.
    """
    executable = True


class MercuryRtdups(MercuryResourceBase):
    """
    Contains pack/rtdups (rtdups binary)
    """
    executable = True
