# coding=utf-8
import logging
from sandbox.projects.common import decorators
from sandbox.projects.common import requests_wrapper
from six.moves.urllib import error

LOGGER = logging.getLogger(__name__)


class ServerError(error.HTTPError):
    pass


class QBot(object):
    BASE_URL = "https://bp.mssngr.yandex.net/bot/"
    SEND_MESSAGE = "telegram_lite/sendMessage/"
    GET_UPDATES = "telegram_lite/getUpdates/"

    def __init__(self, token):
        self.__headers = {"Authorization": "OAuthTeam {token}".format(token=token)}

    @staticmethod
    def _check_status_code(response):
        if response.status_code >= 500:
            raise ServerError
        elif response.status_code >= 400:
            raise error.HTTPError

    @decorators.retries(2, exceptions=(ServerError,))
    def send_message(self, chat_id, text):
        data = {
            "chat_id": chat_id,
            "text": text,
        }
        logging.debug("Send message to chat_id %s, text %s", chat_id, text)
        response = requests_wrapper.post(
            self.BASE_URL + self.SEND_MESSAGE,
            data=data,
            headers=self.__headers,
        )
        LOGGER.debug("Response: %s", response.text)
        self._check_status_code(response)
        return response.json()

    @decorators.retries(2, exceptions=(ServerError,))
    def get_updates(self, offset=None):
        logging.debug("Get updates for QBot, offset is %s", offset)
        params = {}
        if offset:
            params = {
                "offset": offset,
            }
        response = requests_wrapper.get(
            self.BASE_URL + self.GET_UPDATES,
            params=params,
            headers=self.__headers,
        )
        self._check_status_code(response)
        LOGGER.debug("Response: %s", response.text)
        updates = response.json()
        return updates
