# coding=utf-8

import sandbox.projects.common.binary_task as sb_binary_task
from sandbox.common.types import resource as ctr
import sandbox.projects.metrika.utils as utils
import sandbox.projects.metrika.utils.settings as settings
from sandbox import sdk2
# from sandbox.projects.metrika.core.metrika_core_release.release_helper import ReleaseHelper
from sandbox.projects.metrika.utils.base_metrika_task import with_parents
from sandbox.projects.metrika.utils.mixins.dyn_resource import DynResourceMixin
# from sandbox.projects.metrika.utils.notifications import Notifications
from sandbox.projects.metrika.utils.pipeline.pipeline import PipelineBaseTask
from sandbox.projects.metrika.utils.resource_types import METRIKA_RELEASERS


class MetrikaBishopDeployConfig(sdk2.Resource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = METRIKA_RELEASERS
    program = sdk2.Attributes.String('Program', required=True)
    environment = sdk2.Attributes.String('Environment', required=True)
    version = sdk2.Attributes.String('Version', required=True)
    format = sdk2.Attributes.String('Format', required=True)
    restart_policy = ctr.RestartPolicy.IGNORE


@with_parents
class MetrikaBishopConfigRelease(PipelineBaseTask, DynResourceMixin):
    class Parameters(utils.CommonParameters):
        config_version = sdk2.parameters.Integer('Bishop config version', required=True)

        api_url = sdk2.parameters.String('Bishop api url', required=True, default='https://bishop.mtrs.yandex-team.ru/api')

        _binary = sb_binary_task.binary_release_parameters_list(stable=True)

    def create_stages(self):
        return [
            (self.create_resource, 'Создание ресурса'),
            (self.bishop, 'Сохранение в бишопе'),
        ]

    @property
    def bishop_client(self):
        from metrika.pylib.bishop import Bishop

        return Bishop(
            token=sdk2.yav.Secret(settings.yav_uuid).data()['bishop-token'],
            url=self.Parameters.api_url or None,
        )

    def create_resource(self):
        bishop = self.bishop_client

        config = bishop.config.get(self.Parameters.config_version, with_text=True).data
        config_path = self.wd_path('{}/{}/config.{}'.format(config.program, config.environment, config.format))
        config_path.parent.mkdir(parents=True, exist_ok=True)
        config_path.write_text(
            config.text, encoding='utf8'
        )

        MetrikaBishopDeployConfig(
            self,
            'Config version {} for {}/{}'.format(config.id, config.program, config.environment),
            self.wd_path(config.program),
            program=config.program,
            environment=config.environment,
            version=config.id,
            format=config.format,
        )

        config.pop('text')
        self.Context.config = config

    def bishop(self):
        bishop = self.bishcop_client
        config = self.Context.config
        resource = sdk2.Resource.find(
            task=self,
            state=ctr.State.READY,
            resource_type=MetrikaBishopDeployConfig
        ).first()

        bishop.config.set_sandbox_resource_id(config.id, resource.id)

    def get_deploy_tickets(self):
        import metrika.pylib.deploy.client as deploy

        deploy_client = deploy.DeployAPI(token=sdk2.Vault.data(settings.owner, settings.yp_token))

        deploy_release = self.Context.ya_deploy_release_ids[0]
        deploy_client.release.wait_for_deploy_tickets(deploy_release)
        deploy_release_meta = deploy_client.release.get_deploy_tickets(deploy_release, ["/meta"])
        if deploy_release_meta:
            return [meta[0] for meta in deploy_release_meta]
        else:
            return []

    def on_success(self, prev_status):
        pass
        # MTRSADMIN-7564: turn off notifications for testing purposes to prevent spam
        # description = 'Выкладка конфига <a href="https://bishop.mtrs.yandex-team.ru/program/{program}/config/{environment}/{version}">[{version}] {program}/{environment}</a>'.format(
        #     program=self.Context.config['program'], environment=self.Context.config['environment'], version=self.Context.config['id']
        # )

        # developer_message = '{}, вот ссылки для аппрува:'.format(ReleaseHelper.get_duty_telegram('core'))

        # deploy_links = []
        # deploy_tickets = self.get_deploy_tickets()
        # if deploy_tickets:
        #     deploy_links.append(
        #         '🚀 <a href="https://deploy.yandex-team.ru/releases/{}">{}</a>'.format(
        #             self.Context.ya_deploy_release_ids[0], ', '.join(deploy_ticket.get('stage_id') for deploy_ticket in deploy_tickets)
        #         )
        #     )
        # approve_links = '\n'.join(deploy_links)

        # message = '{}\n\n{}\n{}'.format(description, developer_message, approve_links)
        # Notifications.telegram(self, 'Release Approves', message)
