import sys
import os
import os.path
from datetime import datetime
from collections import namedtuple


if __name__ == "__main__":
    from traf_reports.utils.metrika.queries import COUNTERS_QUERY, CHECK_COUNTERS_QUERY, DROP_COUNTERS_QUERY, CREATE_COUNTERS_DB
    from traf_reports.utils.metrika.queries import searches as searches_queries
    from traf_reports.utils.metrika.queries import browsers as browsers_queries
    from traf_reports.utils.metrika import prepare_clickhouse_query

    QUERIES_SETUP = {
        "counters": COUNTERS_QUERY,
        "drop": DROP_COUNTERS_QUERY,
        "create_db": CREATE_COUNTERS_DB,
    }

    QUERIES_TEST = {
        "check": CHECK_COUNTERS_QUERY,
        "searches": searches_queries.SEARCHES_QUERY,
        "non_geobase_searches": searches_queries.NON_GEOBASE_SEARCHES_QUERY,
        "device_model_searches": searches_queries.DEVICE_MODEL_SEARCHES_QUERY,
        "turkey_without_russian_searches": searches_queries.TURKEY_WITHOUT_RUSSIAN_SEARCHES_QUERY,
        "corrected_searches": searches_queries.CORRECTED_SEARCHES_QUERY,
        "windows_10_searches": searches_queries.WINDOWS_10_SEARCHES_QUERY,
        "theme_searches": searches_queries.THEMATIC_SEARCHES_QUERIES,
        "non_geobase_searches_corrected": searches_queries.NON_GEOBASE_SEARCHES_CORRECTED,

        "visits": browsers_queries.VISITS_QUERY,
        "visits_non_search": browsers_queries.VISITS_NON_SEARCH_QUERY,
        "visits_regions": browsers_queries.VISITS_REGIONS_QUERY,
        "visits_crimea": browsers_queries.VISITS_CRIMEA_QUERY,
        "users": browsers_queries.USERS_QUERY,
        "themes": browsers_queries.THEMATIC_QUERY,
        "vendors": browsers_queries.VENDOR_QUERY,
    }


def main():
    scale = 'd'
    current_date = datetime.strptime(sys.argv[1], "%Y-%m-%d")
    destination = os.path.abspath(sys.argv[2])
    Connection = namedtuple('Connection', 'host')
    conn = Connection('mtstat')

    if not os.path.exists(destination):
        os.makedirs(destination)

    setup_destination = os.path.join(destination, "setup")
    os.makedirs(setup_destination)
    for query_name, query_template in QUERIES_SETUP.iteritems():
        print query_name  # noqa
        fn = os.path.join(setup_destination, query_name)
        with open(fn, 'w') as f:
            f.write(prepare_clickhouse_query(query_template, current_date, scale, conn))

    test_destination = os.path.join(destination, "test")
    os.makedirs(test_destination)
    for query_name, query_template in QUERIES_TEST.iteritems():
        print query_name
        fn = os.path.join(test_destination, query_name)
        with open(fn, 'w') as f:
            f.write(prepare_clickhouse_query(query_template, current_date, scale, conn))


if __name__ == '__main__':
    main()
