# coding=utf-8
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils.base_metrika_task import BaseMetrikaTask
from sandbox.projects.metrika.utils import CommonParameters
from sandbox.projects.metrika.utils.parameters import hide, TrackerIssue

from sandbox.projects.metrika.admins.clickhouse.distribution.clickhouse_distribution_import_binary import ClickhouseDistributionImportBinary
from sandbox.projects.metrika.admins.clickhouse.distribution.clickhouse_distribution_import_deb import ClickhouseDistributionImportDeb
from sandbox.projects.metrika.admins.clickhouse.distribution.clickhouse_distribution_import_docker import ClickhouseDistributionImportDocker


class ClickhouseDistributionImport(BaseMetrikaTask):
    """
    Оркестрирующая задача, запускает в параллель задачи, которые выполняют следующие задачи:
    1. Импорт бинаря в специальный ресурс для функциональных тестов.
    2. Импорт deb-пакетов во внутренний репозиторий.
    3. Импорт Docker-image во внутренний registry

    Все они идемпотентные, т.е. уже импортированная версия должна импортироваться успешно.
    """
    class Parameters(CommonParameters):

        version = sdk2.parameters.String("Версия ClickHouse", required=True,
                                         description="Версия, которую нужно импортировать, вида xx.yy.zz.gg")

        ticket = TrackerIssue()

        _binary = hide(binary_task.binary_release_parameters_list(stable=True))

    def on_execute(self):
        self.run_subtasks(
            [
                (ClickhouseDistributionImportBinary,
                 {
                     ClickhouseDistributionImportBinary.Parameters.version.name: self.Parameters.version
                 }),
                (ClickhouseDistributionImportDeb,
                 {
                     ClickhouseDistributionImportDeb.Parameters.version.name: self.Parameters.version
                 }),
                (ClickhouseDistributionImportDocker,
                 {
                     ClickhouseDistributionImportDocker.Parameters.tag.name: self.Parameters.version
                 })
            ]
        )
