# coding=utf-8
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.utils import CommonParameters, settings
from sandbox.projects.metrika.utils.base_metrika_task import BaseMetrikaTask
from sandbox.projects.metrika.utils.mixins.console import BaseConsoleMixin
from sandbox.projects.metrika.utils.parameters import hide
from sandbox.sdk2.helpers import subprocess


class ClickhouseDistributionImportDocker(BaseConsoleMixin, BaseMetrikaTask):
    """
    Задача импортирует указанный Docker-image в указанный репозиторий
    """

    class Parameters(CommonParameters):
        source_image = sdk2.parameters.String("Image-источник", required=True, default="clickhouse/clickhouse-server",
                                              description="Префикс, откуда нужно импортировать")
        tag = sdk2.parameters.String("Тег (версия)", required=True,
                                     description="Версия, которую нужно импортировать, вида xx.yy.zz.gg, она же тег в Docker registry")
        destination_registry = sdk2.parameters.String("Docker-registry назначения", required=True, default="registry.yandex.net")
        destination_image = sdk2.parameters.String("Image-назначение", required=True, default="clickhouse/clickhouse-server",
                                                   description="Префикс, куда нужно импортировать")

        with sdk2.parameters.Group("Секреты"):
            docker_login = sdk2.parameters.String("Docker login", required=True, default=settings.login,
                                                  description="Логин в Docker-registry назначения")
            docker_token = sdk2.parameters.YavSecretWithKey("Docker token", required=True, default="{}#docker-token".format(settings.yav_uuid),
                                                            description="Секрет с токеном для Docker-registry назначения")

        _binary = hide(binary_task.binary_release_parameters_list(stable=True))

    class Requirements(BaseMetrikaTask.Requirements):
        container_resource = 773239891

    def on_execute(self):
        subprocess.check_call(
            "docker login {registry} -u {user} -p $DOCKER_TOKEN".format(registry=self.Parameters.destination_registry, user=self.Parameters.docker_login),
            shell=True,
            env={"DOCKER_TOKEN": self.Parameters.docker_token.value()})

        source_tag = "{}:{}".format(self.Parameters.source_image, self.Parameters.tag)
        destination_tag = "{}/{}:{}".format(self.Parameters.destination_registry, self.Parameters.destination_image, self.Parameters.tag)

        self._execute_shell_and_check(["docker", "pull", source_tag])
        self._execute_shell_and_check(["docker", "tag", source_tag, destination_tag])
        self._execute_shell_and_check(["docker", "push", destination_tag])
