# coding=utf-8
from sandbox.projects.metrika import utils

from sandbox import sdk2
from sandbox.common.types.resource import State
from sandbox.common.types.task import ReleaseStatus
from sandbox.projects.common import binary_task
from sandbox.projects.metrika.admins.clickhouse.build_clickhouse_ip_mapper_dictionary import MetrikaClickhouseIpMapperDictionary
from sandbox.projects.metrika.utils import base_metrika_task
from sandbox.projects.metrika.utils.mixins import juggler_reporter


@base_metrika_task.with_parents
class MetrikaUploadClickhouseIpMapperDictionary(base_metrika_task.BaseMetrikaTask, juggler_reporter.JugglerReporterMixin):
    class Parameters(utils.CommonParameters):
        bucket = sdk2.parameters.String("S3 Bucket name", required=True, default="clickhouse-dictionaries-test")
        endpoint_url = sdk2.parameters.String("S3 endpoint url", required=True, default="https://s3.mds.yandex.net")
        aws_access_key_id = sdk2.parameters.YavSecretWithKey("AWS Access Key ID", required=True, default='sec-01cq6h07rwpqmqzb15y08jbs5q#aws_access_key_id')
        aws_secret_access_key = sdk2.parameters.YavSecretWithKey("AWS Secret Access Key", required=True, default='sec-01cq6h07rwpqmqzb15y08jbs5q#aws_secret_access_key')

        is_report_to_juggler = sdk2.parameters.Bool("Send event to Juggler", required=True, default=False)
        with is_report_to_juggler.value[True]:
            with sdk2.parameters.Group('Juggler'):
                juggler_host = sdk2.parameters.String("Juggler event host", required=True, default='metrika-sandbox-infra-testing')
                juggler_service = sdk2.parameters.String("Juggler event service", required=True)

        _binary = binary_task.binary_release_parameters_list(stable=True)

    def _juggler_predicate(self, status):
        return self.Parameters.is_report_to_juggler

    @property
    def juggler_host(self):
        return self.Parameters.juggler_host

    @property
    def juggler_service(self):
        return self.Parameters.juggler_service

    def on_execute(self):
        import boto3
        from boto3.s3.transfer import S3Transfer
        client = boto3.client(
            's3',
            endpoint_url=self.Parameters.endpoint_url,
            aws_access_key_id=self.Parameters.aws_access_key_id.value(),
            aws_secret_access_key=self.Parameters.aws_secret_access_key.value())
        transfer = S3Transfer(client)
        ip_mapper_file_path = sdk2.ResourceData(MetrikaClickhouseIpMapperDictionary.find(attrs=dict(released=ReleaseStatus.STABLE), state=State.READY).first()).path
        transfer.upload_file(ip_mapper_file_path.as_posix(), self.Parameters.bucket, ip_mapper_file_path.name)
