# coding=utf-8

from sandbox import sdk2
from sandbox.common.utils import get_task_link
from sandbox.projects.metrika import utils
from sandbox.projects.metrika.admins.cosmos.cosmos_runner import ViewModel as RunnerViewModel


class ViewModel(object):
    class Pack(object):

        def __init__(self, name, launcher):
            self._name = name
            self.launcher_task = launcher
            self._runs = self.init_runs()

        def init_runs(self):
            runs = []
            current_run_task = sdk2.Task.find(id=self.launcher_task.Context.packs[self._name]["task_id"]).first()
            while current_run_task is not None:
                runs.append(RunnerViewModel(current_run_task))
                current_run_task = current_run_task.Parameters.rerun_task
            return runs

        @property
        def name(self):
            return utils.display(self._name)

        @property
        def title(self):
            return utils.display(self.launcher_task.Context.packs[self._name]["title"])

        @property
        def runs(self):
            return self._runs

        @property
        def runs_displayable(self):
            """
            :return: возвращает строки с прогонами тестов данного пака.
            Если всего один - то один в любом случае, если более одного, то возвращает на 1 меньше, если у последнего
            нет либо отчётов, либо результатов, что бы не выводить не выполнившуюся задачу на перезапуск тестов.
            """
            if len(self._runs) > 1:
                if self._runs[-1].has_results or self._runs[-1].has_reports:
                    return self._runs
                else:
                    return self._runs[:-1]
            else:
                return self._runs

    def __init__(self, task):
        self.task = task

    @property
    def id(self):
        return self.task.id

    @property
    def link(self):
        return get_task_link(self.task.id)

    @property
    def packs(self):
        return [ViewModel.Pack(name, self.task) for name in self.task.Context.packs.keys()]
