# coding=utf-8

from sandbox import sdk2
from sandbox.common.utils import get_task_link
from sandbox.projects.common.utils import colored_status
from sandbox.projects.metrika import utils


class ViewModel(object):

    def __init__(self, task):
        self.task = task

    @property
    def id(self):
        return self.task.id

    @property
    def link(self):
        return get_task_link(self.task.id)

    @property
    def status(self):
        return colored_status(self.task.status)

    @property
    def name(self):
        return utils.display(self.task.Context.name)

    @property
    def title(self):
        return utils.display(self.task.Context.title)

    @property
    def test_properties(self):
        return self.task.Parameters.test_properties

    @property
    def failed_suites(self):
        return [utils.display(suite) for suite in self.task.Parameters.test_results["failed_suites"]] if self.task.Parameters.test_results else []

    @property
    def has_reports(self):
        return self.task.Parameters.report_resource is not None

    @property
    def link_logs(self):
        return self.__report_link("site/project-reports.html")

    @property
    def link_allure(self):
        return self.__report_link("site/allure-maven-plugin/index.html")

    @property
    def link_surefire(self):
        return self.__report_link("site/surefire-report.html")

    @property
    def link_console_logs(self):
        return self.__report_link("surefire-reports")

    @property
    def link_rerun(self):
        return get_task_link(self.task.Parameters.rerun_task.id) if self.has_rerun else ""

    @property
    def has_rerun(self):
        return self.task.Parameters.rerun_task is not None

    @property
    def has_results(self):
        return self.task.Parameters.test_results is not None

    @property
    def suites_total(self):
        return self.task.Parameters.test_results["total"] if self.has_results else "-"

    @property
    def suites_success(self):
        return self.task.Parameters.test_results["success"] if self.has_results else "-"

    @property
    def suites_failed(self):
        return self.task.Parameters.test_results["failed"] if self.has_results else "-"

    @property
    def reruns_previous(self):
        reruns = []
        if self.task.parent is not None and self.task.parent.type == self.task.type and len(reruns) < 1000:
            current_prev_rerun_task = self.task.parent
            while current_prev_rerun_task is not None and current_prev_rerun_task.type == self.task.type:
                reruns.append(ViewModel(current_prev_rerun_task))
                current_prev_rerun_task = current_prev_rerun_task.parent
        return reruns

    @property
    def rerun_current(self):
        return self.reruns_next[0] if len(self.reruns_next) > 0 else None

    @property
    def has_rerun_current(self):
        return self.rerun_current is not None

    @property
    def run_current(self):
        return ViewModel(self.task)

    @property
    def reruns_next(self):
        reruns = []
        if self.has_rerun:
            current_next_rerun_task = self.task.Parameters.rerun_task
            while current_next_rerun_task is not None and len(reruns) < 1000:
                reruns.append(ViewModel(current_next_rerun_task))
                current_next_rerun_task = current_next_rerun_task.Parameters.rerun_task
        return reruns

    def __report_link(self, rel):
        return sdk2.Resource[self.task.Parameters.report_resource.id].http_proxy + "/" + rel if self.has_reports else ""
