# coding=utf-8
import logging

from lxml import etree


def parse_surefire_reports(path):
    """
    Парсит каталог с surefire репортами https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report.xsd
    :type path: sdk2.Path
    :return:
    """
    suites = {
        "suites": [],
        "failed_suites": [],
        "total": 0,
        "success": 0,
        "failed": 0,
    }
    for p in path.glob("TEST-*.xml"):
        if p.is_file():
            suite = parse_surefire_report(p)
            suites["suites"].append(suite)
            suites["total"] += 1
            if suite["failures"] + suite["broken"] > 0:
                suites["failed_suites"].append(suite["name"])
                suites["failed"] += 1
            else:
                suites["success"] += 1

    return suites


def parse_surefire_report(path):
    """
    Парсит один файл surefire report'а
    :type path: sdk2.Path
    :return:
    """
    suite = {}
    logging.info("Parsing file: {}".format(path.as_posix()))
    test_suite = etree.parse(path.as_posix(), parser=etree.XMLParser(recover=True)).getroot()
    suite["name"] = test_suite.attrib.get("name").encode('utf-8', errors='replace')
    suite["total"] = int(test_suite.attrib.get("tests"))
    suite["failures"] = int(test_suite.attrib.get("failures"))
    suite["broken"] = int(test_suite.attrib.get("errors"))
    suite["cancelled"] = int(test_suite.attrib.get("skipped"))
    suite["success"] = suite["total"] - suite["failures"] - suite["broken"] - suite["cancelled"]

    return suite
