# coding=utf-8

import logging

from sandbox import common
from sandbox import sdk2
from sandbox.projects.metrika.admins.dicts.lib import MetrikaBuildDictionaryCommon
from sandbox.projects.metrika.utils.base_metrika_task import with_parents


@with_parents
class MetrikaBuildHttpDictionary(MetrikaBuildDictionaryCommon):
    class Parameters(MetrikaBuildDictionaryCommon.Parameters):
        skip_header = sdk2.parameters.Bool("Skip header line",
                                           description="Пропускать заголовок из полученной data",
                                           default=False)

    def make_dict(self, skip_header=False):
        import metrika.pylib.http
        import metrika.pylib.escape_utils as mteu

        try:
            response = metrika.pylib.http.request(
                self.dict_config.url,
                retry_if_http_error=True,
                retry_kwargs={
                    'tries': 3,
                }
            )
            logging.debug("Got %d status_code from url: %s", response.status_code, self.dict_config.url)
        except Exception as err:
            message = "Failed to request {}: {}".format(self.dict_config.url, err)
            logging.exception(message)
            raise common.errors.TaskError(message)

        data = response.iter_lines()
        if self.Parameters.skip_header:
            data.next()  # Skip header line
        with open(str(self.dict_file), 'wb') as f:
            for line in data:
                t = map(lambda x: mteu.escape_string(str(x)) if x is not None else '', line.split())
                f.write("\t".join(t))
                f.write("\n")
