import logging

from sandbox import common
from sandbox.projects.metrika.admins.dicts.lib import MetrikaBuildDictionaryCommon
from sandbox.projects.metrika.utils.base_metrika_task import with_parents


@with_parents
class MetrikaBuildYtDictionary(MetrikaBuildDictionaryCommon):
    @property
    def yt_client(self):
        from yt import wrapper
        return wrapper.YtClient(proxy=self.dict_config.proxy, token=self.dict_config.yt.token)

    @property
    def format(self):
        if "format" in self.dict_config:
            return self.dict_config.format

        return "<columns=[{}]>schemaful_dsv".format(";".join(self.dict_config.fields))

    def make_dict(self):
        try:
            logging.debug("Get table {}".format(self.dict_config.table))
            table = self.yt_client.read_table(self.dict_config.table, format=self.format, raw=True)
        except Exception as e:
            logging.exception("Got exception")
            raise common.errors.TaskFailure(str(e))
        else:
            logging.debug("Table received")

        with open(str(self.dict_file), "wb") as table_dump:
            for row in table:
                table_dump.write(row)
